<?php
/**
 * @package admin
 * @copyright Copyright 2003-2011 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 */

//Creates a pull-down list of countries
function zen_get_country_list($name, $selected = '', $parameters = '') {
	$countriesAtTopOfList = array();
	$countries_array = array(array('id' => '', 'text' => PULL_DOWN_DEFAULT));
	$countries = zen_get_countries();

	// Set some default entries at top of list:
	if (STORE_COUNTRY != SHOW_CREATE_ACCOUNT_DEFAULT_COUNTRY) $countriesAtTopOfList[] = SHOW_CREATE_ACCOUNT_DEFAULT_COUNTRY;
	$countriesAtTopOfList[] = STORE_COUNTRY;
	// IF YOU WANT TO ADD MORE DEFAULTS TO THE TOP OF THIS LIST, SIMPLY ENTER THEIR NUMBERS HERE.
	// Duplicate more lines as needed
	// Example: Canada is 108, so use 108 as shown:
	//$countriesAtTopOfList[] = 108;

	//process array of top-of-list entries:
	foreach ($countriesAtTopOfList as $key=>$val) {
		$countries_array[] = array('id' => $val, 'text' => zen_get_country_name($val));
	}
	// now add anything not in the defaults list:
	foreach($countries as $country) {
		$alreadyInList = FALSE;
		foreach($countriesAtTopOfList as $key=>$val) {
			if ($country['id'] == $val)
			{
				// If you don't want to exclude entries already at the top of the list, comment out this next line:
				$alreadyInList = TRUE;
				continue;
			}
		}
		if (!$alreadyInList) $countries_array[] = $country;
	}

	return zen_draw_pull_down_menu($name, $countries_array, $selected, $parameters);
}
