<?php
if (!defined('IS_ADMIN_FLAG')) {
	die('Illegal Access');
}

$version = '1.1';

if(!function_exists('zen_register_admin_page')) {
	$messageStack->add('New Customer v' . $version . ' requires the Zen Cart >= 1.5!' , 'error');
}
else {

	if (!zen_page_key_exists('newCustomer')) {
		// Get the sort order
		$page_sort_query = "SELECT MAX(sort_order) as max_sort FROM `". TABLE_ADMIN_PAGES ."` WHERE menu_key='customers'";
		$page_sort = $db->Execute($page_sort_query);
		$page_sort = $page_sort->fields['max_sort'] + 1;

		// Register the administrative pages
		zen_register_admin_page('newCustomer', 'BOX_CONFIGURATION_NEW_CUSTOMER',
			'FILENAME_NEW_CUSTOMER', '', 'customers', 'N', $page_sort);
	}

	// Now that the menu item has been created/registered, can stop the wasteful process of having
	// this script run again by removing it from the auto-loader array
	if(!@unlink(DIR_FS_ADMIN . DIR_WS_INCLUDES . 'auto_loaders/config.new_customer.php'))
	{
		$messageStack->add(
				'The auto-loader file '. DIR_FS_ADMIN . 'includes/auto_loaders/config.new_customer.php ' .
				'has not been deleted. For this module to work you must delete the ' .
				DIR_FS_ADMIN . 'includes/auto_loaders/config.new_customer.php file manually. ' .
				'Before you post on the Zen Cart forum to ask, YES you are REALLY supposed ' .
				'to follow these instructions and delete '.
				DIR_FS_ADMIN . 'includes/auto_loaders/config.new_customer.php.' , 'error'
		);
	}

	$messageStack->add('New Order v' . $version . ' install completed!' , 'success');
}