<?php
/**
 * @package admin
 * @copyright Copyright 2003-2013 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version GIT: $Id: Author: DrByte  Wed Oct 23 14:38:22 2013 -0400 Modified in v1.5.2 $
 */
  $version_check_index=true;
  require('includes/application_top.php');

  $languages = zen_get_languages();
  $languages_array = array();
  $languages_selected = DEFAULT_LANGUAGE;
  for ($i = 0, $n = sizeof($languages); $i < $n; $i++) {
    $languages_array[] = array('id' => $languages[$i]['code'],
                               'text' => $languages[$i]['name']);
    if ($languages[$i]['directory'] == $_SESSION['language']) {
      $languages_selected = $languages[$i]['code'];
    }
  }
?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<meta name="robots" content="noindex, nofollow" />
<script language="JavaScript" src="includes/menu.js" type="text/JavaScript"></script>
<script language="JavaScript" src="includes/javascript/jscript_slides.min.jquery.js"></script>
<script language="JavaScript" src="includes/javascript/jscript_jquery_1-4-4.js"></script>
<link href="includes/stylesheet.css" rel="stylesheet" type="text/css" />
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS" />
<script type="text/javascript">
  <!--
  function init()
  {
    cssjsmenu('navbar');
    if (document.getElementById)
    {
      var kill = document.getElementById('hoverJS');
      kill.disabled = true;
    }
  }
  // -->
</script>
</head>
<body onLoad="init()">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->
 <?php

  $customers = $db->Execute("select count(*) as count from " . TABLE_CUSTOMERS);
  $new_customers = $db->Execute("select count(customers_info_id) as newcust from " . TABLE_CUSTOMERS_INFO . " where customers_info_date_account_created
  BETWEEN DATE_ADD(NOW(), INTERVAL -7 DAY) AND NOW()");
  $products = $db->Execute("select count(*) as count from " . TABLE_PRODUCTS . " where products_status = '1'");

  $products_off = $db->Execute("select count(*) as count from " . TABLE_PRODUCTS . " where products_status = '0'");
//jc edits
$logFile = "inv_log.txt";
$log_lines = file($logFile);//file in to an array
  $reviews = $db->Execute("select count(*) as count from " . TABLE_REVIEWS);
  $reviews_pending = $db->Execute("select count(*) as count from " . TABLE_REVIEWS . " where status='0'");

  $newsletters = $db->Execute("select count(*) as count from " . TABLE_CUSTOMERS . " where customers_newsletter = '1'");

  $counter_query = "select startdate, counter from " . TABLE_COUNTER;
  $counter = $db->Execute($counter_query);
  $counter_startdate = $counter->fields['startdate'];
//  $counter_startdate_formatted = strftime(DATE_FORMAT_LONG, mktime(0, 0, 0, substr($counter_startdate, 4, 2), substr($counter_startdate, -2), substr($counter_startdate, 0, 4)));
  $counter_startdate_formatted = strftime(DATE_FORMAT_SHORT, mktime(0, 0, 0, substr($counter_startdate, 4, 2), substr($counter_startdate, -2), substr($counter_startdate, 0, 4)));

  $specials = $db->Execute("select count(*) as count from " . TABLE_SPECIALS . " where status= '0'");
  $specials_act = $db->Execute("select count(*) as count from " . TABLE_SPECIALS . " where status= '1'");
  $featured = $db->Execute("select count(*) as count from " . TABLE_FEATURED . " where status= '0'");
  $featured_act = $db->Execute("select count(*) as count from " . TABLE_FEATURED . " where status= '1'");
  $salemaker = $db->Execute("select count(*) as count from " . TABLE_SALEMAKER_SALES . " where sale_status = '0'");
  $salemaker_act = $db->Execute("select count(*) as count from " . TABLE_SALEMAKER_SALES . " where sale_status = '1'");
  $neworders = $db->Execute("select count(orders_id) as neworders
                                 from " . TABLE_ORDERS . "
                                 where orders_status = '1'");
  $weekorders = get_orders_past_week() ; 
   
   $sc_week_orders = '' ;
   ?>
<!-- BOF first row of report boxes -->
<br /><br /><?php echo '<div style="width:100%"><div class="reportbox2"><span class="reportbox_hdr2"><a href="categories.php">' . BOX_TITLE_PRODUCTS . '</a></span>
<table width="100%" height="100%">
<tr height="31%">
<td class="reportbox_leftcell">' . $products->fields['count'] . '</td><td class="reportbox_rightcell"> active products</td></tr>
<tr height="31%">
<td class="reportbox_leftcell">' . $products_off->fields['count'] . '</td><td class="reportbox_rightcell">' . ' inactive products</td></tr>
<tr height="31%">
<td class="reportbox_leftcell">' . ($products->fields['count'] + $products_off->fields['count']) . '</td><td class="reportbox_rightcell">' . ' total products</td></tr>
</table>
</div>
<div class="reportbox2"><span class="reportbox_hdr2"><a href="customers.php">' . BOX_TITLE_CUSTOMERS . '</a></span>
<table width="100%" height="100%">
<tr height="49%">
<td class="reportbox_leftcell">' . $new_customers->fields['newcust'] . '</td><td class="reportbox_rightcell"> New Customers in past week</td></tr>
<tr height="49%">
<td class="reportbox_leftcell">' . $customers->fields['count'] . '</td><td class="reportbox_rightcell">' . ' total customers</td></tr>
</table>
</div><div class="reportbox2"><span class="reportbox_hdr2"><a href="orders.php?selected_box=customers&status=1">' . BOX_TITLE_NEWORDERS . '</a></span>
<table width="100%" height="100%">
<tr height="49%">
<td class="reportbox_leftcell">' . $neworders->fields['neworders'] . '</td><td class="reportbox_rightcell"> New Orders</td></tr>
<tr height="49%">
<td class="reportbox_leftcell">' . $weekorders->fields['weekorders'] . '</td><td class="reportbox_rightcell">' . ' orders in past 7 days</td></tr>
</table>';
$year = date('Y');
$month = date('m');
$py = py_monthly_sales_totals();
$cy = monthly_sales_totals();
$elapsed = date('j');
$numdays = cal_days_in_month(CAL_GREGORIAN, $month, $year);
$projected = ($cy / $elapsed) * $numdays;
$projected_disp = '$' . number_format($projected, 0);
//echo 'projected' . $projected ; 
$diff = $projected - $py;
$diff_per = number_format(((($projected / $py) - 1) * 100), 0) . '%';
//if projected total less than last year, negative trend
if ($diff < 0) {
$class = 'reportbox2 red';
$diff_text = '<span class="diff_text red">-' . $diff_per.'</span>';
$color = 'red';
$arrow = '<img src="images/downarrow.gif" alt="Red Arrow" width="75%"/>';}
else {
$class = 'reportbox2 green';
$diff_text = '<span class="diff_text green">+' . $diff_per.'</span>'; 
$color = 'green';
$arrow = '<img src="images/downarrow.gif" alt="Green Arrow" width="75%"/>';}
echo '</div>';
?>
<style type="text/css">
.tg  {border-collapse:collapse;border-spacing:0;width:100%}
.tg td{font-family:Arial, sans-serif;font-size:14px;max-width:40%;text-align:center}
.tg th{font-family:Arial, sans-serif;font-size:14px;font-weight:normal;}
</style>
<?php 
echo '<div class="' . $class . '"><span class="reportbox_hdr2"><a href="orders.php?selected_box=customers&status=1">' . 'Sales by Period - ' . date('F') . '</a></span>';
echo '<table class="tg">
  <tr width="100%">
    <th class="tg-031e"><span class="index_boxes_small">' . date('M') . '&nbsp;' . (date('Y') -1).'</span></th>
    <th class="tg-031e" rowspan="2" style="color:'.$color.' ; width:30%;">'.$arrow.'</th>
  </tr>
  <tr>
    <td class="tg-031e" style="font-size:2.5em ; font-weight:bold;font-family:Trebuchet MS">$' . number_format($py,0).'</td>
  </tr>
  <tr>
    <td class="tg-031e"><span class="index_boxes_small">&nbsp;' . date('M') . '&nbsp;' . date('Y') . ' Projected</span></td>
    <td class="tg-031e" rowspan="2" style="color:'.$color.'">'.$diff_text.'</td>
  </tr>
  <tr>
    <td class="tg-031e" style="font-size:2.5em ; font-weight:bold;font-family:Trebuchet MS">'.$projected_disp.'</td>
  </tr>
</table>';
echo '</div></div>';
//reads file generated by nightly cron job, results of inventory reports
//line 1 is thumbnails missing
$log_icon1 = ($log_lines[0] == 0 ? 'tick.png' : 'alert_red.gif');
$log_missingthumb_class = ($log_lines[0] == 0 ? 'reportbox6 green' : 'reportbox6 red');

$log_icon3 = ($log_lines[2] == 0 ? 'tick.png' : 'alert_red.gif');
$log_smallimage_class = ($log_lines[2] == 0 ? 'reportbox6 green' : 'reportbox6 red');
//line 3 is orphans
$log_icon2 = ($log_lines[1] == 0 ? 'tick.png' : 'alert_red.gif');
$log_missingsong_class = ($log_lines[1] == 0 ? 'reportbox6 green' : 'reportbox6 red');
echo '<br /><div class="reportbox_blank"><span class="' . $log_smallimage_class . '"><span class="reportbox_leftcell2"><img src="' . DIR_WS_IMAGES . $log_icon3 . '" alt="icon" height="40px" />' . $log_lines[2] . '</span>';
echo '<span class="reportbox_rightcell2"><a href="rt_missing_images.php">Image Too Small</a></span></span>';
echo '<span class="' . $log_missingthumb_class . '"><span class="reportbox_leftcell2"><img src="' . DIR_WS_IMAGES . $log_icon1 . '" alt="icon" height="40px" />' . $log_lines[0] . '</span>
<span class="reportbox_rightcell2"><a href="rt_missing_images.php">Missing Thumbnail Image</a></span></span>
<span class="' . $log_missingsong_class . '"><span class="reportbox_leftcell2"><img src="' . DIR_WS_IMAGES . $log_icon2 . '" alt="icon" height="40px" />' . $log_lines[1] . '</span>
<span class="reportbox_rightcell2"><a href="rt_missing_images.php">Missing Songs</a></span></span></div>';
//echo '<span class="reportbox_leftcell"><img src="' . DIR_WS_IMAGES . $log_missingmed . '" alt="icon" height="25px" />' . $log_lines[0] . '</span> <a href="rt_missing_images.php">Missing Medium Image</a><br />' . '<span class="reportbox_leftcell"><img src="' . DIR_WS_IMAGES . $log_missingthumb . '" alt="icon" height="25px" />' . $log_lines[1] . '</span><span class="reportbox_rightcell"><a href="rt_missing_images.php">Missing Thumbnail</span><br />' . '</a><span class="reportbox_leftcell"><img src="' . DIR_WS_IMAGES . $log_missingsong . '" alt="icon" height="25px" />' . $log_lines[2] . '</span><span class="reportbox_rightcell"><a href="rt_orphans.php">Missing Song</a></span></div>';
//($rt_orphan_count->fields['orphan_count'] > 0 ? $orphan_icon = 'alert.gif' : $orphan_icon = 'tick.png');
//echo $rt_orphan_count->fields['orphan_count'] . '&nbsp;<img src="' . DIR_WS_IMAGES . $orphan_icon. '" alt="Alert" height="20px" />' . '</a>';*/;
	//echo '<br />Inactive SC Items<a href="' . zen_href_link(FILENAME_RT_INACTIVE_ITEMS,'', 'NONSSL') . '">' . $rt_products_off->fields['rt_inactive_count'] . '</a>';
		echo '<div class="reportbox2 bottom"><span class="reportbox_hdr2"><a href="customers.php">' . BOX_TITLE_CUST_DETAILS . '</a></span>';
  $customers = $db->Execute("select c.customers_id as customers_id, c.customers_firstname as customers_firstname, c.customers_lastname as customers_lastname, c.customers_email_address as customers_email_address, a.customers_info_date_account_created as customers_info_date_account_created, a.customers_info_id, ab.entry_company as company from " . TABLE_CUSTOMERS . " c left join " . TABLE_CUSTOMERS_INFO . " a on c.customers_id = a.customers_info_id left join " . TABLE_ADDRESS_BOOK . " ab on c.customers_id = ab.customers_id order by a.customers_info_date_account_created DESC limit 5");
  echo '<table>';
  while (!$customers->EOF) {
    $customers->fields['customers_firstname'] = zen_output_string_protected($customers->fields['customers_firstname']);
    $customers->fields['customers_lastname'] = zen_output_string_protected($customers->fields['customers_lastname']);
    $customers->fields['company'] = zen_output_string_protected($customers->fields['company']);
	(!empty($customers->fields['company'])) ? $cust_display = $customers->fields['company'] : $cust_display = $customers->fields['customers_firstname'] . ' ' . $customers->fields['customers_lastname'];
	echo '<tr><td><a href="' . zen_href_link(FILENAME_CUSTOMERS, 'search=' . $customers->fields['customers_email_address'] . '&origin=' . FILENAME_DEFAULT, 'NONSSL') . '" class="contentlink">' . $cust_display . '</td><td></a>' . zen_date_short($customers->fields['customers_info_date_account_created']) . '</td><tr>';
    $customers->MoveNext();
  }
  echo '</table></div>';
  echo '<div class="reportbox4 bottom"><span class="reportbox_hdr2"><a href="orders.php?selected_box=customers&status=1">' . BOX_TITLE_ORDER_DETAILS . '</a></span>' ;
$orders = $db->Execute("select o.orders_id as orders_id, o.customers_name as customers_name, o.customers_company as company, o.customers_id, o.date_purchased as date_purchased, o.currency, o.currency_value, ot.class, ot.text as order_total from " . TABLE_ORDERS . " o left join " . TABLE_ORDERS_TOTAL . " ot on (o.orders_id = ot.orders_id and class = 'ot_total') order by orders_id DESC limit 5");

  while (!$orders->EOF) {
    zen_not_null($orders->fields['company']) ? $order_name = $orders->fields['company'] : $order_name = $orders->fields['customers_name'];
	echo '              <div class="row"><span style="font-size:.8em ; width:95%"><a href="' . zen_href_link(FILENAME_ORDERS, 'oID=' . $orders->fields['orders_id'] . '&origin=' . FILENAME_DEFAULT, 'NONSSL') . '" class="contentlink"> ' . $order_name . '</a></span><br /><span class="left2">' . 'Order #' . $orders->fields['orders_id'] . ', ' . $orders->fields['order_total'] . ', '. zen_date_short($orders->fields['date_purchased']);
    echo '              </span></span></div>' . "\n";
    $orders->MoveNext();
  }
  //echo '</div>';
  // new box

$py_year = py_yearly_sales_totals();
$cy_year = yearly_sales_totals();
//echo 'cy_year:' . $cy_year;
$elapsed_yr = date('z');
//echo 'elapsed' . $elapsed_yr;
$projected_yr = ($cy_year / $elapsed_yr) * 365;
//echo 'proj yr: ' . $projected_yr;
$projected_yr_disp = '$' . number_format($projected_yr, 0);
//echo 'projected' . $projected ; 
$diff_yr = $projected_yr - $py_year;
$diff_per_yr = number_format(((($projected_yr / $py_year) - 1) * 100), 0) . '%';
//if projected total less than last year, negative trend
if ($diff_yr < 0) {
$class = 'reportbox4 red';
$diff_text = '<span class="diff_text red">' . $diff_per_yr ;
$arrow = '<img src="images/downarrow.gif" alt="Red Arrow" height="55px" />';}
else {
$class = 'reportbox4 green';
$diff_text = '<span class="diff_text green">+' . $diff_per_yr ;
$arrow = '<img src="images/uparrow.gif" alt="Green Arrow" height="55px" /><br />';}  
echo '</div>';
echo '<div class="' . $class . ' bottom"><span class="reportbox_hdr2"><a href="orders.php?selected_box=customers&status=1">' . 'Sales by Year - ' . (date('Y')-1) . ' vs ' . date('Y') . '</a></span>';
echo '<table class="tg">
  <tr>
    <th class="tg-031e"><span class="index_boxes_small">' . (date('Y') -1) . ' Total</span></th>
    <th class="tg-031e" rowspan="3">'.$arrow.'</th>
  </tr>
  <tr>
    <td class="tg-031e" style="font-size:2.5em ; font-weight:bold;font-family:Trebuchet MS">$' . number_format($py_year,0).'</td>
  </tr>
  <tr>
    <td class="tg-031e"><span class="index_boxes_small">' . date('Y') . ' Y-T-D</span></td>
  </tr>
  <tr>
    <td class="tg-031e" style="font-size:2.5em ; font-weight:bold;font-family:Trebuchet MS">$' . number_format($cy_year,0).'</td>
    <td class="tg-031e" rowspan="3">'.$diff_text.'</td>
  </tr>
  <tr>
    <td class="tg-yw4l"><span class="index_boxes_small">&nbsp;' . date('Y') . ' Projected</span></td>
  </tr>
  <tr>
    <td class="tg-yw4l" style="font-size:2.5em ; font-weight:bold;font-family:Trebuchet MS">'.$projected_yr_disp.'</td>
  </tr>
</table>';
echo '</div>';
//echo '</div><div class="' . $class . ' bottom"><span class="reportbox_hdr2"><a href="orders.php?selected_box=customers&status=1">' . 'Sales by Year - ' . (date('Y')-1) . ' vs ' . date('Y') . '</a></span><table><tr><td class="reportbox_leftcell1"><span class="index_small">' . (date('Y') -1) . ' Total</span><br />$' . number_format($py_year,0) . '</td><td class="reportbox_rightcell1" rowspan="3">&nbsp;&nbsp;' . $diff_text . '</td></tr><tr><td class="reportbox_leftcell"><span class="index_small">' . date('Y') . ' Y-T-D</span>$' . number_format($cy_year,0) . '</td></tr><tr><td class="reportbox_leftcell1"><span class="index_small">&nbsp;' . date('Y') . ' Projected</span>' . $projected_yr_disp . '</td></tr></table></div>';
?>
</div>
<!-- The following copyright announcement is in compliance
to section 2c of the GNU General Public License, and
thus can not be removed, or can only be modified
appropriately.

Please leave this comment intact together with the
following copyright announcement. //-->

<div class="copyrightrow"><a href="http://www.zen-cart.com" target="_blank"><img src="images/small_zen_logo.gif" alt="Zen Cart:: the art of e-commerce" border="0" /></a><br /><br />E-Commerce Engine Copyright &copy; 2003-<?php echo date('Y'); ?> <a href="http://www.zen-cart.com" target="_blank">Zen Cart&reg;</a></div><div class="warrantyrow"><br /><br />Zen Cart is derived from: Copyright &copy; 2003 osCommerce<br />This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;<br />without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE<br />and is redistributable under the <a href="http://www.zen-cart.com/license/2_0.txt" target="_blank">GNU General Public License</a><br />
</div>
</body>
</html>
<?php require('includes/application_bottom.php'); ?>