<?php
/*
 * @package admin
//////////////////////////////////////////////////////////////////////////
//  Based on Super Order 2.0                                        	//
//  By Frank Koehl - PM: BlindSide (original author)                	//
//                                                                  	//
//  Super Orders Updated by:						//
//  ~ JT of GTICustom							//
//  ~ C Jones Over the Hill Web Consulting (http://overthehillweb.com)	//
//  ~ Loose Chicken Software Development, david@loosechicken.com	//
//                                                      		//
//////////////////////////////////////////////////////////////////////////
//  DESCRIPTION: Replaces admin/invoice.php, adds amount paid &		//
//  balance due values based on super_order class calculations.  Also	//
//  includes the option to display a tax exemption number, configurable	//
//  from the admin.							//
//////////////////////////////////////////////////////////////////////////
 * @copyright Copyright 2003-2011 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: invoice.php 19136 2011-07-18 16:56:18Z wilt $
*/

  require_once('includes/application_top.php');
  require_once(DIR_WS_CLASSES . 'currencies.php');
 // $currencies = new currencies();
  //require(DIR_WS_CLASSES . 'order.php');
  require_once(DIR_WS_CLASSES . 'super_order.php');

  
  require_once(DIR_WS_CLASSES . 'order.php');
// AJB 2012-05-31 - start (1)
// if(isset($_GET['oID']))
// $oID = zen_db_prepare_input($_GET['oID']);
if(isset($_GET['oID'])) {
	$oID = zen_db_prepare_input($_GET['oID']);
	$batched = false;
	$batch_item = 0;
} else {
	$batched = true;
}

// AJB 2012-05-31 - end (1)
  $order = new order($oID);
  $so = new super_order($oID);
  $currencies = new currencies();

  $display_tax = (TAX_ID_NUMBER == '' ? true : false);
// get residential delivery order status
	$res_status = $db->Execute("SELECT delivery_residential
                                  FROM " . TABLE_ORDERS . "
                                  WHERE orders_id = '" . $oID . "'");

// get customer Sales Tax Exemption ID
$cust_tax = $db->Execute("select customers_taxid, customers_fax
                                    from " . TABLE_CUSTOMERS . "
                                    where customers_id = '" . $order->customer['id'] . "'") ;
  // Find any comments entered at checkout
  // and display on invoice if they exist
  // prepare order-status pulldown list
  $orders_history = $db->Execute("select orders_status_id, date_added, customer_notified, comments, substitutes
                                    from " . TABLE_ORDERS_STATUS_HISTORY . "
                                    where orders_id = '" . zen_db_input($oID) . "' and customer_notified >= 0
                                    order by date_added");
									$orders_statuses = array();
  $orders_status_array = array();
  $orders_status = $db->Execute("select orders_status_id, orders_status_name
                                 from " . TABLE_ORDERS_STATUS . "
                                 where language_id = '" . (int)$_SESSION['languages_id'] . "'");
  while (!$orders_status->EOF) {
    $orders_statuses[] = array('id' => $orders_status->fields['orders_status_id'],
                               'text' => $orders_status->fields['orders_status_name'] . ' [' . $orders_status->fields['orders_status_id'] . ']');
    $orders_status_array[$orders_status->fields['orders_status_id']] = $orders_status->fields['orders_status_name'];
    $orders_status->MoveNext();
  }

?>

<?php // AJB 2012-05-31 - start (2) // ?>
<?php if ($batched == false) {
	$page_title = HEADER_INVOICE . (int)$oID;
} else {
	$page_title = HEADER_INVOICES;
}
?>

<?php if (($batched == false) or ($batched == true and $batch_item == 1)) { ?>

<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo $page_title; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">

<style>
@media screen
{
div.form-separator {border-style:none none solid none;	border-bottom:thick dotted #000000;;}
}
@media print
{
div.form-separator {display: none;}
}
</style>

<script language="javascript" src="includes/menu.js"></script>
<script language="javascript" type="text/javascript"><!--
function couponpopupWindow(url) {
  window.open(url,'popupWindow','toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no,width=450,height=280,screenX=150,screenY=150,top=150,left=150')
}
//--></script>
</head>
<body marginwidth="0" marginheight="0" topmargin="0" bottommargin="0" leftmargin="0" rightmargin="0" bgcolor="#FFFFFF">

<?php } ?>
<?php // AJB 2012-05-31 - end (2) // ?>
<?php
    $prev_oID = $oID - 1;
    $next_oID = $oID + 1;

    $prev_button = '            <a href ="' . zen_href_link(FILENAME_SUPER_INVOICE, 'oID=' . $prev_oID) . '">' . zen_draw_separator('pixel_trans.gif', '50', '30') . '</a>';

    $check_for_next = $db->Execute("SELECT orders_id FROM " . TABLE_ORDERS . " WHERE orders_id = '" . (int)$next_oID . "'");
    if (zen_not_null($check_for_next->fields['orders_id'])) {
      $next_button = '            <a href ="' . zen_href_link(FILENAME_SUPER_INVOICE, 'oID=' . $next_oID) . '">' . zen_draw_separator('pixel_trans.gif', '50', '30') . '</a>';
    }
    else {
      $next_button = '            <a href ="' . zen_href_link(FILENAME_SUPER_ORDERS) . '">' . zen_draw_separator('pixel_trans.gif', '50', '30') . '</a>';
    }
?>

<?php // AJB 2012-05-31 - start (3) // ?>
<?php if (($batched == true) and ($batch_item > 1) and (($batch_item % $forms_per_page) == 0)) { ?>
<!-- <div style="page-break-before:always"><span style="display: none;">&nbsp;</span></div> -->
<br style="page-break-before:always" />
<?php } ?>
<div class="form-separator"></div>
<?php // AJB 2012-05-31 - end (3) // ?>
<!-- body_text //-->

<div style="width:90% ; margin-left:5%">
<div id="invoice_header_bar">INVOICE - ORDER # <?php echo $oID ;?></div>
<?php 
echo '<div id="inv_header_bar2"><span id="inv_store_addr">' . nl2br(STORE_NAME_ADDRESS) . '<br />' . 'Tel: (800) 467-0392</span><span id="inv_logo_box">' . zen_image(DIR_WS_IMAGES . HEADER_LOGO_IMAGE, HEADER_ALT_TEXT, '', '70px') . '<br />' . ENTRY_DATE_PURCHASED . '&nbsp;' . zen_date_short($order->info['date_purchased']) . '</span></div>';
if ($order->billing != $order->delivery) 
{
	echo '<span class="inv_warning">SHIPPING ADDRESS DOES NOT MATCH BILLING ADDRESS</span><br /><br />';
}
$residential = ($res_status->fields['delivery_residential'] == 'Y') ? 'Yes' : 'No';
echo '<div id="invoice_wrapper">';
echo '<span class="invoice_box_thirds"><span class="address_box_label">' . 'Order Info' . '</span>';
for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
    if ($order->totals[$i]['class'] == 'ot_shipping') {
      $format_shipping = explode(" (", $order->totals[$i]['title'], 2);
      $shipping_method = rtrim($format_shipping[0], ":");
      break;
    }
  }
?>
<table border="0" cellspacing="0" cellpadding="2">
	  <tr>
        <td class="main"><strong><?php echo ENTRY_SUBS; ?></strong></td>
        <td class="main"><?php echo $orders_history->fields['substitutes']; ?></td>
      </tr>
      <tr>
        <td class="main"><strong><?php echo ENTRY_PAYMENT_METHOD; ?></strong></td>
        <td class="main"><?php echo $order->info['payment_method']; ?></td>
      </tr>
      <tr>
        <td class="main"><strong><?php echo 'Shipping Method:'; ?></strong></td>
        <td class="main"><?php echo $order->totals[$i]['title']; ?></td>
      </tr>
	   <tr>
        <td class="main"><strong><?php echo 'Email Address:'; ?></strong></td>
        <td class="main"><?php echo $order->customer['email_address']; ?></td>
      </tr>
	   <tr>
        <td class="main"><strong><?php echo 'Phone Number'; ?></strong></td>
        <td class="main"><?php echo $order->customer['telephone']; ?></td>
      </tr>
    </table>
<?php echo '</span>';
echo '<span class="invoice_box_thirds"><span class="address_box_label">' . ENTRY_BILL_TO . '</span>' . str_replace('United States','',zen_address_format($order->customer['format_id'], $order->billing, 1, '', '<br />')) . '</span>';
echo '<span class="invoice_box_thirds"><span class="address_box_label">' . ENTRY_SHIP_TO . '</span>' . str_replace('United States','',zen_address_format($order->delivery['format_id'], $order->delivery, 1, '', '<br />')) . '</span>';
      $order_check = $db->Execute("select cc_cvv, customers_name, customers_company, customers_street_address,
                                    customers_suburb, customers_city, customers_postcode,
                                    customers_state, customers_country, customers_telephone,
                                    customers_email_address, customers_address_format_id, delivery_name,
                                    delivery_company, delivery_street_address, delivery_suburb,
                                    delivery_city, delivery_postcode, delivery_state, delivery_country,
                                    delivery_address_format_id, billing_name, billing_company,
                                    billing_street_address, billing_suburb, billing_city, billing_postcode,
                                    billing_state, billing_country, billing_address_format_id,
                                    payment_method, cc_type, cc_owner, cc_number, cc_expires, currency,
                                    currency_value, date_purchased, orders_status, last_modified
                             from " . TABLE_ORDERS . "
                             where orders_id = '" . (int)$oID . "'");

							 //echo 'Phone Number:' . '&nbsp;&nbsp;' . $order->customer['telephone'] . '<br />Fax Number:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;' . $cust_tax->fields['customers_fax'] . '<br />' . HEADER_TAX_ID . $cust_tax->fields['customers_taxid'] . '<br />eMail:&nbsp;' . '<a href="mailto:' . $order->customer['email_address'] . '">' . $order->customer['email_address'] . '</a>';
          
     ?><br />
		<table border="0" cellpadding="2" cellspacing="0" width="100%">
      <tr class="dataTableHeadingRow">
        <td class="dataTableHeadingContent" width="3%" align="center"><?php echo 'Qty'; ?></td>
		<td class="dataTableHeadingContent" width="10%"><?php echo TABLE_HEADING_PRODUCTS_MODEL; ?></td>
        <td class="dataTableHeadingContent" width="35%"><?php echo 'Name'; ?></td>
		<td class="dataTableHeadingContent" width="10%"><?php echo TABLE_HEADING_PRODUCTS_SIZE; ?></td>
        <td class="dataTableHeadingContent" width="15%"><?php echo TABLE_HEADING_PRODUCTS_SIDES; ?></td>
        <td class="dataTableHeadingContent" align="right" width="10%"><?php echo TABLE_HEADING_PRICE_NO_TAX; ?></td>
        <td class="dataTableHeadingContent" align="right" width="15%"><?php echo TABLE_HEADING_TOTAL_NO_TAX; ?></td>
        </tr>
<?php
    $decimals = $currencies->get_decimal_places($order->info['currency']);
    for ($i = 0, $n = sizeof($order->products); $i < $n; $i++) {
      if (DISPLAY_PRICE_WITH_TAX_ADMIN == 'true')
      {
        $priceIncTax = $currencies->format(zen_round(zen_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']),$decimals) * $order->products[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']);
      } else 
      {
        $priceIncTax = $currencies->format(zen_add_tax($order->products[$i]['final_price'], $order->products[$i]['tax']) * $order->products[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']);
      }
	  $normalQtyArray = array(1,5,10);
      $qty = !in_array($order->products[$i]['qty'], $normalQtyArray) ? '<span style="font-weight:bold ; font-size:1.1em ; text-decoration:underline">'. $order->products[$i]['qty'].'</span>' : $order->products[$i]['qty'];
	  echo '      <tr class="dataTableRow">' . "\n" .
           '        <td class="dataTableContent" valign="top" style="text-align:right">' . $qty . '&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>' . "\n" .
           '        <td class="dataTableContent" valign="top" style="text-align:left">' . $order->products[$i]['model'];

      if (isset($order->products[$i]['attributes']) && (($k = sizeof($order->products[$i]['attributes'])) > 0)) {
        for ($j = 0; $j < $k; $j++) {
          echo '<br><nobr><small>&nbsp;<i> - ' . $order->products[$i]['attributes'][$j]['option'] . ': ' . nl2br(zen_output_string_protected($order->products[$i]['attributes'][$j]['value']));
          if ($order->products[$i]['attributes'][$j]['price'] != '0') echo ' (' . $order->products[$i]['attributes'][$j]['prefix'] . $currencies->format($order->products[$i]['attributes'][$j]['price'] * $order->products[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . ')';
          if ($order->products[$i]['attributes'][$j]['product_attribute_is_free'] == '1' and $order->products[$i]['product_is_free'] == '1') echo TEXT_INFO_ATTRIBUTE_FREE;
          echo '</i></small></nobr>';
        }
      }

      echo '        </td>' . "\n" .
           '        <td class="dataTableContent" valign="top">' . $order->products[$i]['name'] . '</td>' . "\n";
	  echo '        </td>' . "\n" .
           '        <td class="dataTableContent" valign="top">' . $order->products[$i]['size'] . '"</td>' . "\n";
      echo '        </td>' . "\n" .
           '        <td class="dataTableContent" valign="top">' . $order->products[$i]['sides'] . '</td>' . "\n";
     
      echo '<td class="dataTableContent" align="right" valign="top"><strong>' . $currencies->format($order->products[$i]['final_price'], true, $order->info['currency'], $order->info['currency_value']) . '</strong></td>' . "\n" .
           '        <td class="dataTableContent" align="right" valign="top"><strong>' . $currencies->format($order->products[$i]['final_price'] * $order->products[$i]['qty'], true, $order->info['currency'], $order->info['currency_value']) . '</strong></td>' . "\n";
    
    }
?>
      <tr>
        <td colspan="8" align="right"><table border="0" cellpadding="2" cellspacing="0">

<!-- BOF added to get currency type and value for totals -->
                <?php $dbc="select currency, currency_value from " . TABLE_ORDERS . " where orders_id ='" . $_GET['oID'] . "'";
                $result = $db->Execute($dbc);
                $cu = $result->fields['currency'];
				$cv = $result->fields['currency_value'];
                ?>
<!-- EOF added to get currency type and value for totals -->

<?php
  for ($i = 0, $n = sizeof($order->totals); $i < $n; $i++) {
  $display_title = $order->totals[$i]['title'];

    echo '          <tr>' . "\n" .
         '            <td align="right" class="'. str_replace('_', '-', $order->totals[$i]['class']) . '-Text">' . $display_title . '</td>' . "\n" .
         '            <td align="right" class="'. str_replace('_', '-', $order->totals[$i]['class']) . '-Amount">' . $order->totals[$i]['text'] . '</td>' . "\n" .
         '          </tr>' . "\n";
    $order_total = $order->totals[$i]['text'];
  }

    echo '          <tr>' . "\n" .
         '            <td align="right" class="ot-tax-TextPrint">&nbsp;</td>' . "\n" .
         '            <td align="right" class="printMain">&nbsp;</td>' . "\n" .
         '          </tr>' . "\n";

    echo '          <tr>' . "\n" .
         '            <td align="right" class="ot-tax-TextPrint"><strong>'. ENTRY_AMOUNT_APPLIED_CUST .' (' . $cu.')'. '</strong></td>' . "\n" .
         '            <td align="right" class="printMain"><strong>' . $currencies->format($so->amount_applied, true, $order->info['currency'], $order->info['currency_value']) . '</strong></td>' . "\n" .
         '          </tr>' . "\n";

    echo '          <tr>' . "\n" .
         '            <td align="right" class="ot-tax-TextPrint"><strong>'. ENTRY_BALANCE_DUE_CUST .' (' . $cu.')'. '</strong></td>' . "\n" .
         '            <td align="right" class="printMain"><strong>' . $currencies->format($so->balance_due, true, $order->info['currency'], $order->info['currency_value']) . '</strong></td>' . "\n" .
         '          </tr>' . "\n";
?>
        </table>
  <?php if (ORDER_COMMENTS_INVOICE > 0) { ?>
      <table style="float:left"><tr>
        <td class="main"><table border="0" cellspacing="0" cellpadding="5">
          <tr>
            <td class="smallText" align="left"><strong><?php echo TABLE_HEADING_DATE_ADDED; ?></strong></td>
            <td class="smallText" align="left"><strong><?php echo TABLE_HEADING_STATUS; ?></strong></td>
            <td class="smallText" align="left"><strong><?php echo TABLE_HEADING_COMMENTS; ?></strong></td>
          </tr>
<?php
        if ($orders_history->RecordCount() > 0) {
      $count_comments=0;
      while (!$orders_history->EOF) {
        $count_comments++;
        echo '          <tr>' . "\n" .
             '            <td class="smallText" align="left" valign="top">' . zen_datetime_short($orders_history->fields['date_added']) . '</td>' . "\n";
        echo '            <td class="smallText" align="left" valign="top">' . $orders_status_array[$orders_history->fields['orders_status_id']] . '</td>' . "\n";
        echo '            <td class="smallText" align="left" valign="top">' . ($orders_history->fields['comments'] == '' ? TEXT_NONE : nl2br(zen_db_output($orders_history->fields['comments']))) . '&nbsp;</td>' . "\n" .
             '          </tr>' . "\n";
        $orders_history->MoveNext();
        if (ORDER_COMMENTS_INVOICE == 1 && $count_comments >= 1) {
         break;
        }
      }
    } else {
        echo '          <tr>' . "\n" .
             '            <td class="smallText" colspan="5">' . TEXT_NO_ORDER_HISTORY . '</td>' . "\n" .
             '          </tr>' . "\n";
    }
?>
        </table>
<?php } // order comments ?>
</div>


<!-- body_text_eof //-->

<br>
<?php // AJB 2012-05-31 - start (4) // ?>
<?php if (($batched == false) or (($batched == true) and ($batch_item == $number_of_orders))) { ?>
</body>
</html>
<?php } ?>
<?php // AJB 2012-05-31 - end (4) // ?>
<?php require_once(DIR_WS_INCLUDES . 'application_bottom.php'); ?>