<?php
/**
 * new_customer
 *
 * Provides a mechanisim for creating new customers inside the admin interface
 *
 * @copyright Portions Copyright 2012 Andrew Ballanger
 * @copyright Portions Copyright 2003-2006 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 */
require('includes/application_top.php');

$action = (isset($_GET['action']) ? $_GET['action'] : '');

// Load any information submitted
$parameters = array(
	'customers_id' => '0',
	'customers_gender' => '',
	'customers_firstname' => '',
	'customers_lastname' => '',
	'customers_dob' => '0001-01-01 00:00:00',
	'customers_email_address' => '',
	'customers_telephone' => '',
	'customers_fax' => 'null',
	'customers_newsletter' => (ACCOUNT_NEWSLETTER_STATUS == '1' || ACCOUNT_NEWSLETTER_STATUS == '0' ? false : true),
	'customers_email_format' => (ACCOUNT_EMAIL_PREFERENCE == '1' ? 'HTML' : 'TEXT'),
	'customers_default_address_id' => '0',
	'customers_password' => '',
	'customers_group_pricing' => '0',
	'customers_authorization' => (int)CUSTOMERS_APPROVAL_AUTHORIZATION,
	'customers_referral' => '',
	'entry_company' => '',
	'entry_firstname' => '',
	'entry_lastname' => '',
	'entry_street_address' => '',
	'entry_suburb' => '',
	'entry_postcode' => '',
	'entry_city' => '',
	'entry_state' => '',
	'entry_zone_id' => '0',
	'entry_country_id' => '0',
	'billing_firstname' => '',
	'billing_lastname' => '',
	'billing_street_address' => '',
	'billing_suburb' => '',
	'billing_postcode' => '',
	'billing_city' => '',
	'billing_state' => '',
	'billing_zone_id' => '0',
	'billing_country_id' => '0',
	'zone_name' => '',
	'billing_zone_name' => ''
);
$cInfo = new objectInfo($parameters);

$is_post = false;
if(isset($_GET['cID']) && empty($_POST)) {
	// Not needed, but leaving in here for future use
	$query = $db->Execute(
		'SELECT c.customers_id, c.customers_gender, c.customers_firstname, ' .
			'c.customers_lastname, c.customers_dob, c.customers_email_address, ' .
			'a.entry_company, a.entry_street_address, a.entry_suburb, ' .
			'a.entry_postcode, a.entry_city, a.entry_state, a.entry_zone_id, ' .
			'a.entry_country_id, c.customers_telephone, c.customers_fax, ' .
			'c.customers_newsletter, c.customers_default_address_id, ' .
			'c.customers_email_format, c.customers_group_pricing, ' .
			'c.customers_authorization, c.customers_referral ' .
		'FROM `' . TABLE_CUSTOMERS . '` AS c LEFT JOIN `' . TABLE_ADDRESS_BOOK . '` AS a ' .
			'ON c.customers_default_address_id = a.address_book_id ' .
		'WHERE a.customers_id = c.customers_id ' .
			'AND c.customers_id = \'' . (int)$_GET['cID'] . '\''
	);
	$cInfo->objectInfo($query->fields);
}
elseif(zen_not_null($_POST)) {
	$is_post = true;

	$cInfo->objectInfo($_POST);
	$cInfo->customers_id = $_GET['cID'];
	$cInfo->customers_dob = (empty($_POST['customers_dob']) ? zen_db_prepare_input('0001-01-01 00:00:00') : zen_db_prepare_input($_POST['customers_dob']));

	$cInfo->entry_firstname = $cInfo->customers_firstname;
	$cInfo->entry_lastname = $cInfo->customers_lastname;
}

if(zen_not_null($action)) {
	// What was the selected action?
	switch ($action) {
		case 'save': // Not implemented, but leaving in here for future use
		case 'insert':

			// Do some customer validation
			if(ACCOUNT_GENDER == 'true' && $cInfo->customers_gender != 'm' && $cInfo->customers_gender != 'f') {
				$messageStack->add(ENTRY_GENDER_ERROR);
				break;
			}
			if(strlen($cInfo->customers_firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
				$messageStack->add(ENTRY_FIRST_NAME_ERROR);
				break;
			}
			if(strlen($cInfo->customers_lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
				$messageStack->add(ENTRY_LAST_NAME_ERROR);
				break;
			}
			if(ACCOUNT_DOB == 'true' && (ENTRY_DOB_MIN_LENGTH > 0 || !empty($cInfo->customers_dob))) {
				if(substr_count($cInfo->customers_dob,'/') > 2 || checkdate((int)substr(zen_date_raw($cInfo->customers_dob), 4, 2), (int)substr(zen_date_raw($cInfo->customers_dob), 6, 2), (int)substr(zen_date_raw($cInfo->customers_dob), 0, 4)) == false) {
					$messageStack->add(ENTRY_DATE_OF_BIRTH_ERROR);
					break;
				}
			}
			if(ACCOUNT_COMPANY == 'true' && (int)ENTRY_COMPANY_MIN_LENGTH > 0 && strlen($cInfo->entry_company) < ENTRY_COMPANY_MIN_LENGTH) {
				$messageStack->add(ENTRY_COMPANY_ERROR);
				break;
			}
			if(strlen($cInfo->customers_email_address) < ENTRY_EMAIL_ADDRESS_MIN_LENGTH) {
				$messageStack->add(ENTRY_EMAIL_ADDRESS_ERROR);
				break;
			}
			elseif(zen_validate_email($cInfo->customers_email_address) == false) {
				$messageStack->add(ENTRY_EMAIL_ADDRESS_CHECK_ERROR);
				break;
			}
			else {
				$query = 'SELECT count(*) AS total FROM `' . TABLE_CUSTOMERS . '` ' .
					'WHERE `customers_email_address` = \'' . $cInfo->customers_email_address . '\'';
				$check = $db->Execute($query);

				if(!$check->EOF && $check->fields['total'] > 0) {
					$messageStack->add(ENTRY_EMAIL_ADDRESS_ERROR_EXISTS);
					break;
				}
			}
			if(strlen($cInfo->customers_telephone) < ENTRY_TELEPHONE_MIN_LENGTH) {
				$messageStack->add(ENTRY_TELEPHONE_NUMBER_ERROR);
				break;
			}

			// Do some address validation
			if(strlen($cInfo->entry_street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
				$messageStack->add(ENTRY_STREET_ADDRESS_ERROR);
				break;
			}
			if(strlen($cInfo->entry_city) < ENTRY_CITY_MIN_LENGTH) {
				$messageStack->add(ENTRY_CITY_ERROR);
				break;
			}
			if (ACCOUNT_STATE == 'true') {
				$query = 'SELECT count(*) AS total FROM `' . TABLE_ZONES . '` ' .
					'WHERE zone_country_id = :zoneCountryID';
				$query = $db->bindVars($query, ':zoneCountryID', $cInfo->entry_country_id, 'integer');
				$check = $db->Execute($query);

				if($check->EOF || $check->fields['total'] < 1) {
					if (strlen($cInfo->entry_state) < ENTRY_STATE_MIN_LENGTH) {
						$messageStack->add(ENTRY_STATE_ERROR);
						break;
					}
				}

				$query = 'SELECT distinct zone_id, zone_name, zone_code ' .
					'FROM `' . TABLE_ZONES . '`	WHERE zone_country_id = :zoneCountryID AND ' .
						((trim($cInfo->entry_state) != '' && $cinfo->entry_zone_id == 0) ? '(upper(zone_name) like \':zoneState%\' OR upper(zone_code) like \'%:zoneState%\') OR ' : '') .
						'zone_id = :zoneID ' .
					'ORDER BY zone_code ASC, zone_name';

				$query = $db->bindVars($query, ':zoneCountryID', $cInfo->entry_country_id, 'integer');
				$query = $db->bindVars($query, ':zoneState', strtoupper($cInfo->entry_state), 'noquotestring');
				$query = $db->bindVars($query, ':zoneID', $cInfo->entry_zone_id, 'integer');
				$zones = $db->Execute($query);

				//look for an exact match on zone ISO code
				$found_exact_iso_match = ($zones->RecordCount() == 1);
				if($zones->RecordCount() > 1) {
					while(!$zones->EOF && !$found_exact_iso_match) {
						if (strtoupper($zones->fields['zone_code']) == strtoupper($cInfo->entry_state)) {
							$found_exact_iso_match = true;
							continue;
						}
						$zones->MoveNext();
					}
				}

				if($found_exact_iso_match) {
					$cInfo->entry_zone_id = $zones->fields['entry_zone_id'];
					$cInfo->zone_name = $zone->fields['zone_name'];
				}
				else {
					$messageStack->add(ENTRY_STATE_ERROR_SELECT);
					break;
				}
			}
			if(strlen($cInfo->entry_postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
				$messageStack->add(ENTRY_POST_CODE_ERROR);
				break;
			}
			if(is_numeric($cInfo->entry_country_id) == false || $cInfo->entry_country_id < 1) {
				$messageStack->add(ENTRY_COUNTRY_ERROR);
				break;
			}

			// Do some address validation for billing
			$billing_address_sent = $cInfo->billing_firstname != '' ||
				$cInfo->billing_lastname != '' || $cInfo->billing_street_address != '' ||
				$cInfo->billing_suburb != '' || $cInfo->billing_postcode != '' ||
				$cInfo->billing_city != '' || $cInfo->billing_state != '';
			if($billing_address_sent) {
				if(strlen($cInfo->billing_firstname) < ENTRY_FIRST_NAME_MIN_LENGTH) {
					$messageStack->add(ENTRY_FIRST_NAME_ERROR);
					break;
				}
				if(strlen($cInfo->billing_lastname) < ENTRY_LAST_NAME_MIN_LENGTH) {
					$messageStack->add(ENTRY_LAST_NAME_ERROR);
					break;
				}
				if(strlen($cInfo->billing_street_address) < ENTRY_STREET_ADDRESS_MIN_LENGTH) {
					$messageStack->add(ENTRY_STREET_ADDRESS_ERROR);
					break;
				}
				if(strlen($cInfo->billing_city) < ENTRY_CITY_MIN_LENGTH) {
					$messageStack->add(ENTRY_CITY_ERROR);
					break;
				}
				if (ACCOUNT_STATE == 'true') {
					$query = 'SELECT count(*) AS total FROM `' . TABLE_ZONES . '` ' .
						'WHERE zone_country_id = :zoneCountryID';
					$query = $db->bindVars($query, ':zoneCountryID', $cInfo->billing_country_id, 'integer');
					$check = $db->Execute($query);

					if($check->EOF || $check->fields['total'] < 1) {
						if (strlen($cInfo->billing_state) < ENTRY_STATE_MIN_LENGTH) {
							$messageStack->add(ENTRY_STATE_ERROR);
							break;
						}
					}

					$query = 'SELECT distinct zone_id, zone_name, zone_code ' .
						'FROM `' . TABLE_ZONES . '`	WHERE zone_country_id = :zoneCountryID AND ' .
							((trim($cInfo->billing_state) != '' && $cinfo->billing_zone_id == 0) ? '(upper(zone_name) like \':zoneState%\' OR upper(zone_code) like \'%:zoneState%\') OR ' : '') .
							'zone_id = :zoneID ' .
						'ORDER BY zone_code ASC, zone_name';

					$query = $db->bindVars($query, ':zoneCountryID', $cInfo->billing_country_id, 'integer');
					$query = $db->bindVars($query, ':zoneState', strtoupper($cInfo->billing_state), 'noquotestring');
					$query = $db->bindVars($query, ':zoneID', $cInfo->billing_zone_id, 'integer');
					$zones = $db->Execute($query);

					//look for an exact match on zone ISO code
					$found_exact_iso_match = ($zones->RecordCount() == 1);
					if($zones->RecordCount() > 1) {
						while(!$zones->EOF && !$found_exact_iso_match) {
							if (strtoupper($zones->fields['zone_code']) == strtoupper($cInfo->billing_state)) {
								$found_exact_iso_match = true;
								continue;
							}
							$zones->MoveNext();
						}
					}

					if($found_exact_iso_match) {
						$cInfo->billing_zone_id = $zones->fields['entry_zone_id'];
						$cInfo->billing_zone_name = $zone->fields['zone_name'];
					}
					else {
						$messageStack->add(ENTRY_STATE_ERROR_SELECT);
						break;
					}
				}
				if(strlen($cInfo->billing_postcode) < ENTRY_POSTCODE_MIN_LENGTH) {
					$messageStack->add(ENTRY_POST_CODE_ERROR);
					break;
				}
				if(is_numeric($cInfo->billing_country_id) == false || $cInfo->billing_country_id < 1) {
					$messageStack->add(ENTRY_COUNTRY_ERROR);
					break;
				}
			}

			// Generate password
			if(function_exists('zen_create_PADSS_password')) {
				$cInfo->customers_password = zen_create_PADSS_password((int)ENTRY_PASSWORD_MIN_LENGTH > 0 ? (int)ENTRY_PASSWORD_MIN_LENGTH : 5);
			}
			else {
				$cInfo->customers_password = zen_create_random_value((int)ENTRY_PASSWORD_MIN_LENGTH > 0 ? (int)ENTRY_PASSWORD_MIN_LENGTH : 5);
			}
			$cInfo->customers_password = zen_encrypt_password($cInfo->customers_password);

			$sql_data_array = array(
				'customers_gender' => $cInfo->customers_gender,
				'customers_firstname' => $cInfo->customers_firstname,
				'customers_lastname' => $cInfo->customers_lastname,
				'customers_dob' => $cInfo->customers_dob,
				'customers_email_address' => $cInfo->customers_email_address,
				'customers_telephone' => $cInfo->customers_telephone,
				'customers_fax' => $cInfo->customers_fax,
				'customers_newsletter' => $cInfo->customers_newsletter,
				'customers_email_format' => $cInfo->customers_email_format,
				'customers_default_address_id' => $cInfo->customers_default_address_id,
				'customers_password' => $cInfo->customers_password,
				'customers_group_pricing' => $cInfo->customers_group_pricing,
				'customers_authorization' => $cInfo->customers_authorization,
				'customers_referral' => $cInfo->customers_referral
			);
			zen_db_perform(TABLE_CUSTOMERS, $sql_data_array);
			$cInfo->customers_id = $db->Insert_ID();

			// TODO: send notification
			//$zco_notifier->notify('NOTIFY_MODULE_CREATE_ACCOUNT_ADDED_CUSTOMER_RECORD', array_merge(array('customer_id' => $cInfo->customers_id), $sql_data_array));

			$sql_data_array = array(
				'customers_id' => $cInfo->customers_id,
				'entry_company' => $cInfo->entry_company,
				'entry_firstname' => $cInfo->entry_firstname,
				'entry_lastname' => $cInfo->entry_lastname,
				'entry_street_address' => $cInfo->entry_street_address,
				'entry_suburb' => $cInfo->entry_suburb,
				'entry_postcode' => $cInfo->entry_postcode,
				'entry_city' => $cInfo->entry_city,
				'entry_state' => $cInfo->entry_state,
				'entry_zone_id' => $cInfo->entry_zone_id,
				'entry_country_id' => $cInfo->entry_country_id
			);
			zen_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);
			$cInfo->customers_default_address_id = $db->Insert_ID();

			// TODO: send notification
			//$zco_notifier->notify('NOTIFY_MODULE_CREATE_ACCOUNT_ADDED_ADDRESS_BOOK_RECORD', array_merge(array('address_id' => $cInfo->customers_default_address_id), $sql_data_array));

			$sql_data_array = array(
				'customers_default_address_id' => $cInfo->customers_default_address_id
			);
			zen_db_perform(TABLE_CUSTOMERS, $sql_data_array, 'update', 'customers_id = \'' . (int)$cInfo->customers_id . '\'');

			$sql_data_array = array(
				'customers_info_id' => (int)$cInfo->customers_id,
				'customers_info_number_of_logons' => 0,
				'customers_info_date_account_created' => 'now()'
			);
			zen_db_perform(TABLE_CUSTOMERS_INFO, $sql_data_array);

			if($billing_address_sent) {
				$sql_data_array = array(
					'customers_id' => $cInfo->customers_id,
					'entry_firstname' => $cInfo->billing_firstname,
					'entry_lastname' => $cInfo->billing_lastname,
					'entry_street_address' => $cInfo->billing_street_address,
					'entry_suburb' => $cInfo->billing_suburb,
					'entry_postcode' => $cInfo->billing_postcode,
					'entry_city' => $cInfo->billing_city,
					'entry_state' => $cInfo->billing_state,
					'entry_zone_id' => $cInfo->billing_zone_id,
					'entry_country_id' => $cInfo->billing_country_id
				);
				zen_db_perform(TABLE_ADDRESS_BOOK, $sql_data_array);
			}

			// Send account created email and redirect back to the customer list
			$admname = '{' . preg_replace('/[^\d\w]/', '*', zen_get_admin_name()) . '[' . (int)$_SESSION['admin_id'] . ']}';
			$msg = sprintf(TEXT_EMAIL_MESSAGE_NEW_ACCOUNT_CREATED, $cInfo->customers_firstname . ' ' . $cInfo->customers_lastname, $admname);
			zen_mail(STORE_OWNER_EMAIL_ADDRESS, STORE_OWNER_EMAIL_ADDRESS, TEXT_EMAIL_SUBJECT_NEW_ACCOUNT_CREATED, $msg, STORE_NAME, EMAIL_FROM, array('EMAIL_MESSAGE_HTML'=>$msg), 'new_customer');
			zen_redirect(zen_href_link(FILENAME_CUSTOMERS, 'cID=' . $cInfo->customers_id));
		default:
	}
}
$selected_country = (isset($_POST['entry_country_id']) && $cInfo->entry_country_id != '') ? $cInfo->entry_country_id : SHOW_CREATE_ACCOUNT_DEFAULT_COUNTRY;
$flag_show_pulldown_states = ((isset($_POST['entry_zone_id']) && $cInfo->entry_zone_id != '') || ACCOUNT_STATE_DRAW_INITIAL_DROPDOWN == 'true') ? true : false;
//$state = ($flag_show_pulldown_states) ? ($cInfo->entry_state == '' ? '&nbsp;' : $cInfo->entry_state) : $cInfo->zone_name;
//$billing_state = ($flag_show_pulldown_states) ? ($cInfo->billing_state == '' ? '&nbsp;' : $cInfo->billing_state) : $cInfo->billing_zone_name;
$state_field_label = ($flag_show_pulldown_states) ? '&nbsp' : ENTRY_STATE;

?>
<!doctype html public "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<link rel="stylesheet" type="text/css" href="includes/cssjsmenuhover.css" media="all" id="hoverJS">
<style type="text/css">
legend {
	font-weight: bold;
}
label.inputLabel {
	display: inline-block;
	float: left;
	width: 14em;
}
</style>
<script language="javascript" src="includes/menu.js"></script>
<script type="text/javascript"><!--
function init()
{
	cssjsmenu('navbar');
	if (document.getElementById)
	{
		var kill = document.getElementById('hoverJS');
		kill.disabled = true;
	}

	update_zone(document.new_customer);
	update_billing_zone(document.new_customer);
}

function update_zone(theForm) {
	// if there is no zone_id field to update, or if it is hidden from display, then exit performing no updates
    if (!theForm || !theForm.elements["entry_zone_id"]) return;
    if (theForm.entry_zone_id.type == "hidden") return;

    // set initial values
    var SelectedCountry = theForm.entry_country_id.options[theForm.entry_country_id.selectedIndex].value;
    var SelectedZone = theForm.elements["entry_zone_id"].value;

    // reset the array of pulldown options so it can be repopulated
    var NumState = theForm.entry_zone_id.options.length;
    while(NumState > 0) {
		NumState = NumState - 1;
		theForm.entry_zone_id.options[NumState] = null;
    }
    // build dynamic list of countries/zones for pulldown
	<?php echo zen_js_zone_list('SelectedCountry', 'theForm', 'entry_zone_id'); ?>

    // if we had a value before reset, set it again
	if (SelectedZone != "") theForm.elements["entry_zone_id"].value = SelectedZone;
}

function update_billing_zone(theForm) {
	// if there is no zone_id field to update, or if it is hidden from display, then exit performing no updates
    if (!theForm || !theForm.elements["billing_zone_id"]) return;
    if (theForm.billing_zone_id.type == "hidden") return;

    // set initial values
    var SelectedCountry = theForm.billing_country_id.options[theForm.billing_country_id.selectedIndex].value;
    var SelectedZone = theForm.elements["billing_zone_id"].value;

    // reset the array of pulldown options so it can be repopulated
    var NumState = theForm.billing_zone_id.options.length;
    while(NumState > 0) {
		NumState = NumState - 1;
		theForm.billing_zone_id.options[NumState] = null;
    }
    // build dynamic list of countries/zones for pulldown
	<?php echo zen_js_billing_zone_list('SelectedCountry', 'theForm', 'billing_zone_id'); ?>

    // if we had a value before reset, set it again
	if (SelectedZone != "") theForm.elements["billing_zone_id"].value = SelectedZone;
}

function hideStateField(theForm) {
	theForm.entry_state.disabled = true;
	theForm.entry_state.className = 'hiddenField';
	theForm.entry_state.setAttribute('className', 'hiddenField');
	document.getElementById("stateLabel").className = 'hiddenField';
	document.getElementById("stateLabel").setAttribute('className', 'hiddenField');
	document.getElementById("stText").className = 'hiddenField';
	document.getElementById("stText").setAttribute('className', 'hiddenField');
	document.getElementById("stBreak").className = 'hiddenField';
	document.getElementById("stBreak").setAttribute('className', 'hiddenField');
}
function hideBillingStateField(theForm) {
	theForm.billing_state.disabled = true;
	theForm.billing_state.className = 'hiddenField';
	theForm.billing_state.setAttribute('className', 'hiddenField');
	document.getElementById("billingstateLabel").className = 'hiddenField';
	document.getElementById("billingstateLabel").setAttribute('className', 'hiddenField');
	document.getElementById("billingstText").className = 'hiddenField';
	document.getElementById("billingstText").setAttribute('className', 'hiddenField');
	document.getElementById("billingstBreak").className = 'hiddenField';
	document.getElementById("billingstBreak").setAttribute('className', 'hiddenField');
}

function showStateField(theForm) {
	theForm.entry_state.disabled = false;
	theForm.entry_state.className = 'inputLabel visibleField';
	theForm.entry_state.setAttribute('className', 'visibleField');
	document.getElementById("stateLabel").className = 'inputLabel visibleField';
	document.getElementById("stateLabel").setAttribute('className', 'inputLabel visibleField');
	document.getElementById("stText").className = 'alert visibleField';
	document.getElementById("stText").setAttribute('className', 'alert visibleField');
	document.getElementById("stBreak").className = 'clearBoth visibleField';
	document.getElementById("stBreak").setAttribute('className', 'clear visibleField');
}
function showBillingStateField(theForm) {
	theForm.billing_state.disabled = false;
	theForm.billing_state.className = 'inputLabel visibleField';
	theForm.billing_state.setAttribute('className', 'visibleField');
	document.getElementById("billingstateLabel").className = 'inputLabel visibleField';
	document.getElementById("billingstateLabel").setAttribute('className', 'inputLabel visibleField');
	document.getElementById("billingstText").className = 'alert visibleField';
	document.getElementById("billingstText").setAttribute('className', 'alert visibleField');
	document.getElementById("billingstBreak").className = 'clearBoth visibleField';
	document.getElementById("billingstBreak").setAttribute('className', 'clear visibleField');
}
// -->
</script>
<script language="javascript" type="text/javascript"><!--
var selected;

function check_form_optional(form_name) {
  var form = form_name;
  if (!form.elements['customers_firstname']) {
    return true;
  } else {
    var firstname = form.elements['customers_firstname'].value;
    var lastname = form.elements['customers_lastname'].value;
    var street_address = form.elements['entry_street_address'].value;

    if (firstname == '' && lastname == '' && street_address == '') {
      return true;
    } else {
      return check_form(form_name);
    }
  }
}
var form = "";
var submitted = false;
var error = false;
var error_message = "";

function check_input(field_name, field_size, message) {
  if (form.elements[field_name] && (form.elements[field_name].type != "hidden")) {
    if (field_size == 0) return;
    var field_value = form.elements[field_name].value;

    if (field_value == '' || field_value.length < field_size) {
      error_message = error_message + "* " + message + "\n";
      error = true;
    }
  }
}

function check_radio(field_name, message) {
  var isChecked = false;

  if (form.elements[field_name] && (form.elements[field_name].type != "hidden")) {
    var radio = form.elements[field_name];

    for (var i=0; i<radio.length; i++) {
      if (radio[i].checked == true) {
        isChecked = true;
        break;
      }
    }

    if (isChecked == false) {
      error_message = error_message + "* " + message + "\n";
      error = true;
    }
  }
}

function check_select(field_name, field_default, message) {
  if (form.elements[field_name] && (form.elements[field_name].type != "hidden")) {
    var field_value = form.elements[field_name].value;

    if (field_value == field_default) {
      error_message = error_message + "* " + message + "\n";
      error = true;
    }
  }
}

function check_state(field_name, zone_field_name, min_length, min_message, select_message) {
  if (form.elements[field_name] && form.elements[zone_field_name]) {
    if (!form.elements[field_name].disabled && form.elements[zone_field_name].value == "") check_input(field_name, min_length, min_message);
  } else if (form.elements[field_name] && form.elements[field_name].type != "hidden" && form.elements[field_name].disabled) {
    check_select(zone_field_name, "", select_message);
  }
}

function check_form(form_name) {
  if (submitted == true) {
    alert("<?php echo JS_ERROR_SUBMITTED; ?>");
    return false;
  }

  error = false;
  form = form_name;
  error_message = "<?php echo JS_ERROR; ?>";

<?php if (ACCOUNT_GENDER == 'true') echo '  check_radio("customers_gender", \'' . ENTRY_GENDER_ERROR . '\');' . "\n"; ?>

<?php if ((int)ENTRY_FIRST_NAME_MIN_LENGTH > 0) { ?>
  check_input("customers_firstname", <?php echo (int)ENTRY_FIRST_NAME_MIN_LENGTH; ?>, '<?php echo ENTRY_FIRST_NAME_ERROR; ?>');
<?php } ?>
<?php if ((int)ENTRY_LAST_NAME_MIN_LENGTH > 0) { ?>
  check_input("customers_lastname", <?php echo (int)ENTRY_LAST_NAME_MIN_LENGTH; ?>, '<?php echo ENTRY_LAST_NAME_ERROR; ?>');
<?php } ?>

<?php if (ACCOUNT_DOB == 'true' && (int)ENTRY_DOB_MIN_LENGTH != 0) echo '  check_input("customers_dob", ' . (int)ENTRY_DOB_MIN_LENGTH . ', \'' . ENTRY_DATE_OF_BIRTH_ERROR . '\');' . "\n"; ?>
<?php if (ACCOUNT_COMPANY == 'true' && (int)ENTRY_COMPANY_MIN_LENGTH != 0) echo '  check_input("entry_company", ' . (int)ENTRY_COMPANY_MIN_LENGTH . ', \'' . ENTRY_COMPANY_ERROR . '\');' . "\n"; ?>

<?php if ((int)ENTRY_EMAIL_ADDRESS_MIN_LENGTH > 0) { ?>
  check_input("customers_email_address", <?php echo (int)ENTRY_EMAIL_ADDRESS_MIN_LENGTH; ?>, '<?php echo ENTRY_EMAIL_ADDRESS_ERROR; ?>');
<?php } ?>
<?php if ((int)ENTRY_STREET_ADDRESS_MIN_LENGTH > 0) { ?>
  check_input("street_address", <?php echo (int)ENTRY_STREET_ADDRESS_MIN_LENGTH; ?>, '<?php echo ENTRY_STREET_ADDRESS_ERROR; ?>');
<?php } ?>
<?php if ((int)ENTRY_POSTCODE_MIN_LENGTH > 0) { ?>
  check_input("entry_postcode", <?php echo (int)ENTRY_POSTCODE_MIN_LENGTH; ?>, '<?php echo ENTRY_POST_CODE_ERROR; ?>');
<?php } ?>
<?php if ((int)ENTRY_CITY_MIN_LENGTH > 0) { ?>
  check_input("entry_city", <?php echo (int)ENTRY_CITY_MIN_LENGTH; ?>, '<?php echo ENTRY_CITY_ERROR; ?>');
<?php } ?>
<?php if (ACCOUNT_STATE == 'true') { ?>
  check_state("entry_state", "entry_zone_id", <?php echo (int)ENTRY_STATE_MIN_LENGTH . ', \'' . ENTRY_STATE_ERROR . '\', \'' . ENTRY_STATE_ERROR_SELECT; ?>');
<?php } ?>

  check_select("entry_country_id", "", '<?php echo ENTRY_COUNTRY_ERROR; ?>');

var billing_address_sent = form.billing_firstname.value != '' ||
	form.billing_lastname.value != '' || form.billing_street_address.value != '' ||
	form.billing_suburb.value != '' || form.billing_postcode.value != '' ||
	form.billing_city.value != '' || form.billing_state.value != '';

if(billing_address_sent) {<?php
	if ((int)ENTRY_FIRST_NAME_MIN_LENGTH > 0) { ?>
  check_input("billing_firstname", <?php echo (int)ENTRY_FIRST_NAME_MIN_LENGTH; ?>, '<?php echo ENTRY_FIRST_NAME_ERROR; ?>');<?php
	}
	if ((int)ENTRY_LAST_NAME_MIN_LENGTH > 0) { ?>
  check_input("billing_lastname", <?php echo (int)ENTRY_LAST_NAME_MIN_LENGTH; ?>, '<?php echo ENTRY_LAST_NAME_ERROR; ?>');<?php
	}
	if ((int)ENTRY_STREET_ADDRESS_MIN_LENGTH > 0) { ?>
  check_input("billing_street_address", <?php echo (int)ENTRY_STREET_ADDRESS_MIN_LENGTH; ?>, '<?php echo ENTRY_STREET_ADDRESS_ERROR; ?>');<?php
	}
	if ((int)ENTRY_POSTCODE_MIN_LENGTH > 0) { ?>
  check_input("billing_postcode", <?php echo (int)ENTRY_POSTCODE_MIN_LENGTH; ?>, '<?php echo ENTRY_POST_CODE_ERROR; ?>');<?php
	}
	if ((int)ENTRY_CITY_MIN_LENGTH > 0) { ?>
  check_input("billing_city", <?php echo (int)ENTRY_CITY_MIN_LENGTH; ?>, '<?php echo ENTRY_CITY_ERROR; ?>');<?php
	}
	if (ACCOUNT_STATE == 'true') { ?>
  check_state("billing_state", "billing_zone_id", <?php echo (int)ENTRY_STATE_MIN_LENGTH . ', \'' . ENTRY_STATE_ERROR . '\', \'' . ENTRY_STATE_ERROR_SELECT; ?>');<?php
	} ?>
  check_select("billing_country_id", "", '<?php echo ENTRY_COUNTRY_ERROR; ?>');
}
<?php if ((int)ENTRY_TELEPHONE_MIN_LENGTH > 0) { ?>
  check_input("customers_telephone", <?php echo ENTRY_TELEPHONE_MIN_LENGTH; ?>, '<?php echo ENTRY_TELEPHONE_NUMBER_ERROR; ?>');
<?php } ?>

  if (error == true) {
    alert(error_message);
    return false;
  } else {
    submitted = true;
    return true;
  }
}
//-->
</script>
</head>
<body onload="init()">
	<!-- header //-->
	<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
	<!-- header_eof //-->
	<!-- body //-->
	<table border="0" width="100%" cellspacing="2" cellpadding="2">
		<tr>
			<!-- body_text //-->
			<td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
				<tr>
					<td width="100%"><table border="0" width="100%" cellspacing="0" cellpadding="0">
						<tr>
							<td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
							<td class="pageHeading" align="right"><?php echo zen_draw_separator('pixel_trans.gif', HEADING_IMAGE_WIDTH, HEADING_IMAGE_HEIGHT); ?></td>
						</tr>
					</table></td>
				</tr>
				<tr>
					<td><?php echo zen_draw_form('new_customer', FILENAME_NEW_CUSTOMER, 'action=insert', 'post', 'enctype="multipart/form-data" onsubmit="return check_form(new_customer);"');
if(ACCOUNT_COMPANY == 'true') { ?>
						<fieldset>
							<legend><?php echo CATEGORY_COMPANY; ?></legend>
							<label class="inputLabel" for="entry_company"><?php echo ENTRY_COMPANY; ?></label>
							<?php echo zen_draw_input_field('entry_company', ($is_post ? $cInfo->entry_company : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_company', '40') . ' id="entry_company"') . (zen_not_null(ENTRY_COMPANY_TEXT) ? '<span class="alert">' . ENTRY_COMPANY_TEXT . '</span>': ''); ?>
						</fieldset><?php
} ?>
						<fieldset>
							<legend><?php echo TABLE_HEADING_ADDRESS_DETAILS; ?></legend><?php
if(ACCOUNT_GENDER == 'true') { ?>
							<?php echo zen_draw_radio_field('customers_gender', 'm', '', 'id="gender-male"') . '<label class="radioButtonLabel" for="gender-male">' . MALE . '</label>' . zen_draw_radio_field('customers_gender', 'f', '', 'id="gender-female"') . '<label class="radioButtonLabel" for="gender-female">' . FEMALE . '</label>' . (zen_not_null(ENTRY_GENDER_TEXT) ? '<span class="alert">' . ENTRY_GENDER_TEXT . '</span>': ''); ?>
							<br class="clear" /><?php
} ?>
							<label class="inputLabel" for="customers_firstname"><?php echo ENTRY_FIRST_NAME; ?></label>
							<?php echo zen_draw_input_field('customers_firstname', ($is_post ? $cInfo->customers_firstname : ''), zen_set_field_length(TABLE_CUSTOMERS, 'customers_firstname', '40') . ' id="customers_firstname"') . (zen_not_null(ENTRY_FIRST_NAME_TEXT) ? '<span class="alert">' . ENTRY_FIRST_NAME_TEXT . '</span>': ''); ?>
							<br class="clear" />
							<label class="inputLabel" for="customers_lastname"><?php echo ENTRY_LAST_NAME; ?></label>
							<?php echo zen_draw_input_field('customers_lastname', ($is_post ? $cInfo->customers_lastname : ''), zen_set_field_length(TABLE_CUSTOMERS, 'customers_lastname', '40') . ' id="customers_lastname"') . (zen_not_null(ENTRY_LAST_NAME_TEXT) ? '<span class="alert">' . ENTRY_LAST_NAME_TEXT . '</span>': ''); ?>
							<br class="clear" />
							<label class="inputLabel" for="entry_street_address"><?php echo ENTRY_STREET_ADDRESS; ?></label>
							<?php echo zen_draw_input_field('entry_street_address', ($is_post ? $cInfo->entry_street_address : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_street_address', '40') . ' id="entry_street_address"') . (zen_not_null(ENTRY_STREET_ADDRESS_TEXT) ? '<span class="alert">' . ENTRY_STREET_ADDRESS_TEXT . '</span>': ''); ?>
							<br class="clear" /><?php
if(ACCOUNT_SUBURB == 'true') { ?>
							<label class="inputLabel" for="entry_suburb"><?php echo ENTRY_SUBURB; ?></label>
							<?php echo zen_draw_input_field('entry_suburb', ($is_post ? $cInfo->entry_suburb : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_suburb', '40') . ' id="entry_suburb"') . (zen_not_null(ENTRY_SUBURB_TEXT) ? '<span class="alert">' . ENTRY_SUBURB_TEXT . '</span>': ''); ?>
							<br class="clear" /><?php
} ?>
							<label class="inputLabel" for="entry_city"><?php echo ENTRY_CITY; ?></label>
							<?php echo zen_draw_input_field('entry_city', ($is_post ? $cInfo->entry_city : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_city', '40') . ' id="entry_city"') . (zen_not_null(ENTRY_CITY_TEXT) ? '<span class="alert">' . ENTRY_CITY_TEXT . '</span>': ''); ?>
							<br class="clear" /><?php
if(ACCOUNT_STATE == 'true') {
	if($flag_show_pulldown_states == true) { ?>
							<label class="inputLabel" for="entry_zone_id" id="zoneLabel"><?php echo ENTRY_STATE; ?></label>
							<?php
		echo zen_draw_pull_down_menu('entry_zone_id', zen_prepare_country_zones_pull_down($selected_country), $cInfo->entry_zone_id, 'id="entry_zone_id"');
		if(zen_not_null(ENTRY_STATE_TEXT)) echo '&nbsp;<span class="alert">' . ENTRY_STATE_TEXT . '</span>'; ?>
							<br class="clear" id="stBreak" /><?php
	} ?>
							<label class="inputLabel" for="entry_state" id="stateLabel"><?php echo $state_field_label; ?></label>
							<?php
	echo zen_draw_input_field('entry_state', '', zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_state', '40') . ' id="entry_state"');
	if(zen_not_null(ENTRY_STATE_TEXT)) echo '&nbsp;<span class="alert" id="stText">' . ENTRY_STATE_TEXT . '</span>';
	if($flag_show_pulldown_states == false) {
		echo zen_draw_hidden_field('entry_zone_id', $cInfo->zone_name, ' ');
	} ?>
							<br class="clear" /><?php
} ?>
							<label class="inputLabel" for="entry_postcode"><?php echo ENTRY_POST_CODE; ?></label>
							<?php echo zen_draw_input_field('entry_postcode', ($is_post ? $cInfo->entry_postcode : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_postcode', '40') . ' id="entry_postcode"') . (zen_not_null(ENTRY_POST_CODE_TEXT) ? '<span class="alert">' . ENTRY_POST_CODE_TEXT . '</span>': ''); ?>
							<br class="clear" />
							<label class="inputLabel" for="entry_country_id"><?php echo ENTRY_COUNTRY; ?></label>
							<?php echo zen_get_country_list('entry_country_id', $selected_country, 'id="entry_country_id" ' . ($flag_show_pulldown_states == true ? 'onchange="update_zone(this.form);"' : '')) . (zen_not_null(ENTRY_COUNTRY_TEXT) ? '<span class="alert">' . ENTRY_COUNTRY_TEXT . '</span>': ''); ?>
							<br class="clear" />
						</fieldset>
						<fieldset>
							<legend><?php echo TABLE_HEADING_BILLING_ADDRESS_DETAILS; ?></legend>
							<label class="inputLabel" for="billing_firstname"><?php echo ENTRY_FIRST_NAME; ?></label>
							<?php echo zen_draw_input_field('billing_firstname', ($is_post ? $cInfo->billing_firstname : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_firstname', '40') . ' id="billing_firstname"') . (zen_not_null(ENTRY_FIRST_NAME_TEXT) ? '<span class="alert">' . ENTRY_FIRST_NAME_TEXT . '</span>': ''); ?>
							<br class="clear" />
							<label class="inputLabel" for="billing_lastname"><?php echo ENTRY_LAST_NAME; ?></label>
							<?php echo zen_draw_input_field('billing_lastname', ($is_post ? $cInfo->billing_lastname : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_lastname', '40') . ' id="billing_lastname"') . (zen_not_null(ENTRY_LAST_NAME_TEXT) ? '<span class="alert">' . ENTRY_LAST_NAME_TEXT . '</span>': ''); ?>
							<br class="clear" />
							<label class="inputLabel" for="billing_street_address"><?php echo ENTRY_STREET_ADDRESS; ?></label>
							<?php echo zen_draw_input_field('billing_street_address', ($is_post ? $cInfo->billing_street_address : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_street_address', '40') . ' id="billing_street_address"') . (zen_not_null(ENTRY_STREET_ADDRESS_TEXT) ? '<span class="alert">' . ENTRY_STREET_ADDRESS_TEXT . '</span>': ''); ?>
							<br class="clear" /><?php
if(ACCOUNT_SUBURB == 'true') { ?>
							<label class="inputLabel" for="billing_suburb"><?php echo ENTRY_SUBURB; ?></label>
							<?php echo zen_draw_input_field('billing_suburb', ($is_post ? $cInfo->billing_suburb : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_suburb', '40') . ' id="billing_suburb"') . (zen_not_null(ENTRY_SUBURB_TEXT) ? '<span class="alert">' . ENTRY_SUBURB_TEXT . '</span>': ''); ?>
							<br class="clear" /><?php
} ?>
							<label class="inputLabel" for="billing_city"><?php echo ENTRY_CITY; ?></label>
							<?php echo zen_draw_input_field('billing_city', ($is_post ? $cInfo->billing_city : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_city', '40') . ' id="billing_city"') . (zen_not_null(ENTRY_CITY_TEXT) ? '<span class="alert">' . ENTRY_CITY_TEXT . '</span>': ''); ?>
							<br class="clear" /><?php
if(ACCOUNT_STATE == 'true') {
	if($flag_show_pulldown_states == true) { ?>
							<label class="inputLabel" for="billing_zone_id" id="billingzoneLabel"><?php echo ENTRY_STATE; ?></label>
							<?php
		echo zen_draw_pull_down_menu('billing_zone_id', zen_prepare_country_zones_pull_down($selected_country), $cInfo->billing_zone_id, 'id="billing_zone_id"');
		if(zen_not_null(ENTRY_STATE_TEXT)) echo '&nbsp;<span class="alert">' . ENTRY_STATE_TEXT . '</span>'; ?>
							<br class="clear" id="billingstBreak" /><?php
	} ?>
							<label class="inputLabel" for="billing_state" id="billingstateLabel"><?php echo $state_field_label; ?></label>
							<?php
	echo zen_draw_input_field('billing_state', '', zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_state', '40') . ' id="billing_state"');
	if(zen_not_null(ENTRY_STATE_TEXT)) echo '&nbsp;<span class="alert" id="billingstText">' . ENTRY_STATE_TEXT . '</span>';
	if($flag_show_pulldown_states == false) {
		echo zen_draw_hidden_field('billing_zone_id', $cInfo->billing_zone_name, ' ');
	} ?>
							<br class="clear" /><?php
} ?>
							<label class="inputLabel" for="billing_postcode"><?php echo ENTRY_POST_CODE; ?></label>
							<?php echo zen_draw_input_field('billing_postcode', ($is_post ? $cInfo->billing_postcode : ''), zen_set_field_length(TABLE_ADDRESS_BOOK, 'entry_postcode', '40') . ' id="billing_postcode"') . (zen_not_null(ENTRY_POST_CODE_TEXT) ? '<span class="alert">' . ENTRY_POST_CODE_TEXT . '</span>': ''); ?>
							<br class="clear" />
							<label class="inputLabel" for="billing_country_id"><?php echo ENTRY_COUNTRY; ?></label>
							<?php echo zen_get_country_list('billing_country_id', $selected_country, 'id="billing_country_id" ' . ($flag_show_pulldown_states == true ? 'onchange="update_billing_zone(this.form);"' : '')) . (zen_not_null(ENTRY_COUNTRY_TEXT) ? '<span class="alert">' . ENTRY_COUNTRY_TEXT . '</span>': ''); ?>
							<br class="clear" />
						</fieldset>
						<fieldset>
							<legend><?php echo TABLE_HEADING_PHONE_FAX_DETAILS; ?></legend>
							<label class="inputLabel" for="customers_telephone"><?php echo ENTRY_TELEPHONE_NUMBER; ?></label>
							<?php echo zen_draw_input_field('customers_telephone', ($is_post ? $cInfo->customers_telephone : ''), zen_set_field_length(TABLE_CUSTOMERS, 'customers_telephone', '40') . ' id="customers_telephone"') . (zen_not_null(ENTRY_TELEPHONE_NUMBER_TEXT) ? '<span class="alert">' . ENTRY_TELEPHONE_NUMBER_TEXT . '</span>': '');
if(ACCOUNT_FAX_NUMBER == 'true') { ?>
							<br class="clear" />
							<label class="inputLabel" for="customers_fax"><?php echo ENTRY_FAX_NUMBER; ?></label>
							<?php echo zen_draw_input_field('customers_fax', ($is_post ? $cInfo->customers_fax : ''), 'id="customers_fax"') . (zen_not_null(ENTRY_FAX_NUMBER_TEXT) ? '<span class="alert">' . ENTRY_FAX_NUMBER_TEXT . '</span>': '');
}
if(ACCOUNT_DOB == 'true') { ?>
							<br class="clear" />
							<label class="inputLabel" for="customers_dob"><?php echo ENTRY_DATE_OF_BIRTH; ?></label>
							<?php echo zen_draw_input_field('customers_dob', ($is_post ? $cInfo->customers_dob : ''), 'id="customers_dob"') . (zen_not_null(ENTRY_DATE_OF_BIRTH_TEXT) ? '<span class="alert">' . ENTRY_DATE_OF_BIRTH_TEXT . '</span>': '');
} ?>
						</fieldset>
						<fieldset>
							<legend><?php echo TABLE_HEADING_LOGIN_DETAILS; ?></legend>
							<label class="inputLabel" for="customers_email_address"><?php echo ENTRY_EMAIL_ADDRESS; ?></label>
							<?php echo zen_draw_input_field('customers_email_address', ($is_post ? $cInfo->customers_email_address : ''), zen_set_field_length(TABLE_CUSTOMERS, 'customers_email_address', '40') . ' id="customers_email_address"') . (zen_not_null(ENTRY_EMAIL_ADDRESS_TEXT) ? '<span class="alert">' . ENTRY_EMAIL_ADDRESS_TEXT . '</span>': ''); ?>
							<br class="clear" />
						</fieldset>
						<fieldset>
							<legend><?php echo ENTRY_EMAIL_PREFERENCE; ?></legend><?php
if(ACCOUNT_NEWSLETTER_STATUS != 0) { ?>
							<?php echo zen_draw_checkbox_field('customers_newsletter', '1', $newsletter, 'id="customers_newsletter"') . '<label class="checkboxLabel" for="customers_newsletter">' . ENTRY_NEWSLETTER . '</label>' . (zen_not_null(ENTRY_NEWSLETTER_TEXT) ? '<span class="alert">' . ENTRY_NEWSLETTER_TEXT . '</span>': ''); ?>
							<br class="clear" /><?php
} ?>
							<?php echo zen_draw_radio_field('customers_email_format', 'HTML', ($email_format == 'HTML' ? true : false),'id="customers_email_format"') . '<label class="radioButtonLabel">' . ENTRY_EMAIL_HTML_DISPLAY . '</label>' .  zen_draw_radio_field('customers_email_format', 'TEXT', ($email_format == 'TEXT' ? true : false), 'id="email-format-text"') . '<label class="radioButtonLabel">' . ENTRY_EMAIL_TEXT_DISPLAY . '</label>'; ?>
							<br class="clear" />
						</fieldset><?php
if(CUSTOMERS_REFERRAL_STATUS == 2) {
?>
						<fieldset>
							<legend><?php echo TABLE_HEADING_REFERRAL_DETAILS; ?></legend>
							<label class="inputLabel" for="customers_referral"><?php echo ENTRY_CUSTOMERS_REFERRAL; ?></label>
							<?php echo zen_draw_input_field('customers_referral', '', zen_set_field_length(TABLE_CUSTOMERS, 'customers_referral', '15') . ' id="customers_referral"'); ?>
							<br class="clear" />
						</fieldset><?php
}

if($messageStack->size > 0) echo $messageStack->output(); ?>
						<div class="buttonRow floatRight"><?php echo zen_image_submit('button_insert.gif', IMAGE_INSERT); ?></div>
					</form></td>
				</tr>
			<!-- body_text_eof //-->
			</table></td>
		</tr>
	</table>
	<!-- body_eof //-->

	<!-- footer //-->
	<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
	<!-- footer_eof //-->
	<br />
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>