<?php
/**
 * Footer Menu Definitions
 *
 * @package templateSystem
 * @copyright Copyright 2003-2005 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V3.0
 * @version $Id: footer_menu_deines.php 1.0 5/9/2009 Clyde Jones $
 */

/*BOF Menu Column 1 link Definitions*/
Define('TITLE_ONE', '<li class="menuTitle">Contact Information</li>');
Define('PHONE', '<li class="footer-phone"><a href=""><img src="includes/templates/cambridge_pro/images/phone.png" alt="phone number" class="footer-icon" />800-467-0392</a></li>');
Define('EMAIL', '<li class="footer-phone"><a href="' . zen_href_link(FILENAME_CONTACT_US) . '"><img src="includes/templates/cambridge_pro/images/newsletter_icon.gif" alt="email us" class="footer-icon email-icon" />Email Us</a></li>');
/*EOF Menu Column 1 link Definitions*/

/*OF Menu Column 2 link Definitions*/
Define('TITLE_TWO', '<li class="menuTitle">Shopping Links</li>');
Define('FEATURED', '<li><a href="' . zen_href_link(FILENAME_FEATURED_PRODUCTS) . '">Featured Products</a></li>');
Define('SPECIALS', '<li><a href="' . zen_href_link(FILENAME_SPECIALS) . '">Specials / Sales</a></li>');
Define('NEWPRODUCTS', '<li><a href="' . zen_href_link(FILENAME_PRODUCTS_NEW) . '">New Products</a></li>');
Define('ADVSEARCH', '<li><a href="' . zen_href_link(FILENAME_ADVANCED_SEARCH) . '">Advanced Search</a></li>');
/*EOF Menu Column 2 link Definitions*/

/*BOF Menu Column 3 link Definitions*/
Define('TITLE_THREE', '<li class="menuTitle">Account Links</li>');
Define('CONTACT','<li><a href="' . zen_href_link(FILENAME_CONTACT_US) . '">' . BOX_INFORMATION_CONTACT . '</a></li>');
Define('SHIPPING', '<li><a href="' . zen_href_link(FILENAME_SHIPPING) . '">' . BOX_INFORMATION_SHIPPING . '</a></li>');
Define('PRIVACY', '<li><a href="' . zen_href_link(FILENAME_PRIVACY) . '">' . BOX_INFORMATION_PRIVACY . '</a></li>');
Define('CONDITIONS','<li><a href="' . zen_href_link(FILENAME_CONDITIONS) . '">' . BOX_INFORMATION_CONDITIONS . '</a></li>');
Define('LOGIN', '<li><a href="' . zen_href_link(FILENAME_LOGIN, '', 'SSL') .'">Login / Create Account</a></li>');
Define('LOGOFF', '<li><a href="' . zen_href_link(FILENAME_LOGOFF, '', 'SSL') .'">Log Off</a></li>');
Define('ACCOUNT', '<li><a href="' . zen_href_link(FILENAME_ACCOUNT, '', 'SSL') .'">' . HEADER_TITLE_MY_ACCOUNT . '</a></li>');
Define('ORDERS', '<li><a href="' . zen_href_link(FILENAME_ACCOUNT, '', 'SSL') .'">Order History</a></li>');
Define('UNSUBSCRIBE', '<li><a href="' . zen_href_link(FILENAME_UNSUBSCRIBE) .'">Newsletter Unsubscribe</a></li>');
/*EOF Menu Column 3 link Definitions*/

/*BOF Menu Column 4 link Definitions*/
Define('TITLE_FOUR', '<li class="menuTitle">Useful Links</li>');
Define('CATALOGS','<li><a href="index.php?main_page=page&id=1&chapter=0">View Catalogs</a></li>');
Define('HOLIDAYS', '<li><a href="' . zen_href_link('page_2') . '">Holiday Calendar</a></li>');
Define('SHIPPING', '<li><a href="' . zen_href_link(FILENAME_SHIPPING) . '">Shipping / Returns</a></li>');
Define('SITEMAP','<li><a href="' . zen_href_link(FILENAME_SITEMAP) . '">Site Map</a></li>');
Define('CART','<li><a href="' . zen_href_link(FILENAME_SHOPPING_CART) . '">Shopping Cart</a></li>');
/*The actual links are determined by "footer links" set in EZ-Pages
*EOF Menu Column 4 link Definitions
*/

/*bof bottom footer definitions*/
Define('FOOTER_PAYMENT_ICON', 'paypal.png');
Define('FACEBOOK_ICON', 'facebook.png');
Define('TWITTER_ICON', 'twitter.png');
Define('YOUTUBE_ICON', 'youtube.png');
Define('PINTEREST_ICON', 'pinterest.png');
Define('GOOGLE_ICON', 'google.png');
Define('BLOG_ICON', 'blog.png');

/*bof bottom footer text definitions*/
Define('FACEBOOK_TEXT', 'Become a Fan');
Define('TWITTER_TEXT', 'Follow Us');
Define('YOUTUBE_TEXT', 'Subscribe');
Define('PINTEREST_TEXT', 'Come Pin with Us');
Define('GOOGLE_TEXT', 'Recommend Us');
Define('BLOG_TEXT', 'Our Blog');

/*bof bottom footer urls*/
Define('FACEBOOK','http://www.facebook.com/Custom.Zen.Cart.Design');
Define('TWITTER', 'http://www.twitter.com/nikkisballoons');
Define('YOUTUBE', '');
Define('PINTEREST', '');
Define('GOOGLE', '');
Define('BLOG', '');

/*BOF Footer Menu Definitions*/
Define('QUICKLINKS', '<dd class="first">
<ul>' . TITLE_ONE . PHONE . EMAIL . '</ul></dd>');
Define('INFORMATION', '<dd class="second">
<ul>' . TITLE_TWO . FEATURED . SPECIALS . NEWPRODUCTS . ADVSEARCH . '</ul></dd>');
Define('CUSTOMER_SERVICE', '<dd class="third">
<ul>' . TITLE_THREE . LOGOFF . ACCOUNT . ORDERS . UNSUBSCRIBE . '</ul></dd>');
Define('CUSTOMER_SERVICE_NOT', '<dd class="third">
<ul>' . TITLE_THREE . LOGIN . ACCOUNT . ORDERS . UNSUBSCRIBE . '</ul></dd>');
Define('USEFUL', '<dd class="fourth">
<ul>' . TITLE_FOUR . CATALOGS . HOLIDAYS . SHIPPING . CART . '</ul></dd>');
/*EOF Footer Menu Definitions*/

 

//EOF