<?php
/**
 * Page Template
 *
 * Loaded automatically by index.php?main_page=checkout_shipping.<br />
 * Displays allowed shipping modules for selection by customer.
 *
 * @package templateSystem
 * @copyright Copyright 2003-2013 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version GIT: $Id: Author: Ian Wilson  Mon Oct 28 17:54:33 2013 +0000 Modified in v1.5.2 $
 */
?>
<div class="centerColumn" id="checkoutShipping">

<?php echo zen_draw_form('checkout_address', zen_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL')) . zen_draw_hidden_field('action', 'process'); ?>

<?php 
echo '<div class="ckout_status_bar"><div class="ckout_bar pink"><div id="circle">1</div>Shipping Information</div><div class="ckout_bar gray">';
if (zen_not_null($_SESSION['payment'])) {
echo '<a href="' . zen_href_link(FILENAME_CHECKOUT_PAYMENT) . '"><div id="circle">2</div>Payment Information</a>';}
else {
echo '<div id="circle">2</div>Payment Information';}
echo '</div><div class="ckout_bar gray"><div id="circle">3</div>Review & Confirm</div></div><br /><br />';
echo '<span class="shipping_addr_block"><span class="select_text">Please confirm your shipping address and select a shipping method</span><br /><br /><address class="checkoutAddress"><span style="font-size:1.1;font-weight:bold;font-family:Raleway;color:#E012A2">SHIPPING ADDRESS</span><br />' . html_entity_decode(zen_address_label($_SESSION['customer_id'], $_SESSION['sendto'], true, ' ', '<br />')) . '<br /><br /><a id="linkCheckoutShippingAddr" href="' . zen_href_link(FILENAME_CHECKOUT_SHIPPING_ADDRESS, '', 'SSL') . '">' . zen_image_button(BUTTON_IMAGE_CHANGE_ADDRESS, BUTTON_CHANGE_ADDRESS_ALT) . '</a></address><br /><br />' . zen_draw_textarea_field('comments', '45', '3', TABLE_HEADING_COMMENTS, 'class="ckout_comments"') . '</span>';

echo '<span class="shipping_addr_block">';

if (zen_count_shipping_modules() > 0) {
	if (sizeof($quotes) > 1 && sizeof($quotes[0]) > 1)
	{
		?>
		<div id="checkoutShippingContentChoose" class="important"><?php //echo TEXT_CHOOSE_SHIPPING_METHOD; ?></div>
		<?php
	} 
	elseif ($free_shipping == false) 
	{
		?>
		<div id="checkoutShippingContentChoose" class="important"><?php echo TEXT_ENTER_SHIPPING_INFORMATION; ?></div>
		<?php
	}
	if ($free_shipping == true) 
	{
		?>
		<div id="freeShip" class="important" ><?php echo FREE_SHIPPING_TITLE; ?>&nbsp;<?php echo $quotes[$i]['icon']; ?></div>
		<div id="defaultSelected"><?php echo sprintf(FREE_SHIPPING_DESCRIPTION, $currencies->format(MODULE_ORDER_TOTAL_SHIPPING_FREE_SHIPPING_OVER)) . zen_draw_hidden_field('shipping', 'free_free'); ?></div>
		<?php
	} 
	else 
	{
		$radio_buttons = 0;
		//var_dump($_SESSION);    
		echo '<fieldset class="checkout"><legend>Shipping Methods</legend>';
		for ($i=0, $n=sizeof($quotes); $i<$n; $i++) 
		{
			// bof: field set
			// allows FedEx to work comment comment out Standard and Uncomment FedEx
			//      if ($quotes[$i]['id'] != '' || $quotes[$i]['module'] != '') { // FedEx
			if ($quotes[$i]['module'] != '') 
			{ // Standard
				?>
				<fieldset>
				<legend><?php echo $quotes[$i]['module']; ?>&nbsp;<?php if (isset($quotes[$i]['icon']) && zen_not_null($quotes[$i]['icon'])) { echo $quotes[$i]['icon']; } ?></legend>
				<?php
	            if (isset($quotes[$i]['error'])) 
				{
					?>
					<div><?php echo $quotes[$i]['error']; ?></div>
					<?php
				} 
				else
				{
					for ($j=0, $n2=sizeof($quotes[$i]['methods']); $j<$n2; $j++) 
					{
						// set the radio button to be checked if it is the method chosen
						$checked = FALSE;
						if (isset($_SESSION['shipping']) && isset($_SESSION['shipping']['id'])) 
						{
						  $checked = ($quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'] == $_SESSION['shipping']['id']);
						}
						if ( ($checked == true) || ($n == 1 && $n2 == 1) )
						{
							//echo '      <div id="defaultSelected" class="moduleRowSelected">' . "\n";
							//} else {
							//echo '      <div class="moduleRow">' . "\n";
						}
						if ( ($n > 1) || ($n2 > 1) )
						{
							?>
							<div class="important forward"><?php echo '<div class="shippingamt">' . $currencies->format(zen_add_tax($quotes[$i]['methods'][$j]['cost'], (isset($quotes[$i]['tax']) ? $quotes[$i]['tax'] : 0))); ?></div></div>
							<?php
						} 
						else
						{
							?>
							<div class="important forward" id="shipping_rate"><?php echo $currencies->format(zen_add_tax($quotes[$i]['methods'][$j]['cost'], $quotes[$i]['tax'])) . zen_draw_hidden_field('shipping', $quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id']); ?></div>
							<?php
						}	
						?>
						<?php echo zen_draw_radio_field('shipping', $quotes[$i]['id'] . '_' . $quotes[$i]['methods'][$j]['id'], $checked, 'id="ship-'.$quotes[$i]['id'] . '-' . $quotes[$i]['methods'][$j]['id'].'"'); ?>
						<label for="ship-<?php echo $quotes[$i]['id'] . '-' . $quotes[$i]['methods'][$j]['id']; ?>" class="checkboxLabel" ><?php echo $quotes[$i]['icon'] . '&nbsp;&nbsp;' . $quotes[$i]['methods'][$j]['title'] ; ?></label>
						<br class="clearBoth" />
						<?php		
						$radio_buttons++;
					}
					// BOF Captcha
					if(is_object($captcha)) 
					{
						echo $captcha->img();
						echo $captcha->redraw_button(BUTTON_IMAGE_CAPTCHA_REDRAW, BUTTON_IMAGE_CAPTCHA_REDRAW_ALT); ?>
						<br class="clearBoth" />
						<label for="captcha"><?php echo TITLE_CAPTCHA; ?></label>
						<?php echo $captcha->input_field('captcha', 'id="captcha"') . '&nbsp;<span class="alert">' . TEXT_CAPTCHA . '</span>'; ?>
						<br class="clearBoth" />
						<?php	
					}
					// EOF Captcha          
				}
			}
			echo '</fieldset>';
		}?>
		<fieldset id="checkout_subs"><legend id= "Allow Substitutes?"><?php echo 'Allow Substitutions?' ?></legend>
		<div id= "ckout_subs"> <?php echo zen_draw_checkbox_field('sub', '1', false, 'id="sub"'); ?><?php echo '&nbsp;' . '&nbsp;' . '&nbsp;' ?>
		<?php echo 'In the event the an item is sold out, check here to allow substitutes for similar designs of equal value'; ?> </div></fieldset><?php
		echo '<span id="ckout_shipping_continue3">' . zen_image_submit('next_step.png', 'Continue to Next Step') . '</span></form>';
		//onclick="updateForm();
	}
	  
}
else
{
    ?>
    <h2 id="checkoutShippingHeadingMethod"><?php echo TITLE_NO_SHIPPING_AVAILABLE; ?></h2>
    <div id="checkoutShippingContentChoose" class="important"><?php echo TEXT_NO_SHIPPING_AVAILABLE; ?></div>
    <?php
}
?>
</div>