<?php
/**
 * Page Template
 *
 * @package templateSystem
 * @copyright Copyright 2003-2005 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: tpl_password_forgotten_default.php 3712 2006-06-05 20:54:13Z drbyte $
 */
?>
<div class="centerColumn" id="passwordForgotten">
<?php echo zen_draw_form('password_forgotten', zen_href_link(FILENAME_PASSWORD_FORGOTTEN, 'action=process', 'SSL')); ?>

<?php if ($messageStack->size('password_forgotten') > 0) echo $messageStack->output('password_forgotten'); ?>

<fieldset>
<legend><?php echo HEADING_TITLE; ?></legend>

<div id="passwordForgottenMainContent" class="content"><?php echo TEXT_MAIN; ?></div>

<div class="alert text-right"><?php echo FORM_REQUIRED_INFORMATION; ?></div>
<br class="clearBoth" />

<div class="ui-field-contain">
<label for="email-address"><?php echo ENTRY_EMAIL_ADDRESS . (zen_not_null(ENTRY_EMAIL_ADDRESS_TEXT) ? '<span class="alert">' . ENTRY_EMAIL_ADDRESS_TEXT . '</span>': ''); ?></label>
<?php echo zen_draw_input_field('email_address', '', zen_set_field_length(TABLE_CUSTOMERS, 'customers_email_address', '40') . ' id="email-address" placeholder="' . ENTRY_EMAIL_ADDRESS . '"') . '&nbsp;'; ?>
</div>
</fieldset>

<div class="button-row ui-grid-a">
    <div class="ui-block-a">
        <?php echo jqm_back_link() . jqm_button_widget(true,'','',false,false,ANCHOR_BTN_THEME,false,true,false,true) . '">' . BUTTON_BACK_ALT . '</a>'; ?>
    </div>

    <div class="ui-block-b">
		<?php echo jqm_submit_button(BUTTON_IMAGE_SUBMIT, BUTTON_SUBMIT_ALT); ?>
    </div>
</div>

</form>
</div>