<?php
/**
 * Page Template
 *
 * Loaded automatically by index.php?main_page=product_info.<br />
 * Displays details of a typical product
 *
 * @package templateSystem
 * @copyright Copyright 2003-2014 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id:  $
 */
 //require(DIR_WS_MODULES . '/debug_blocks/product_info_prices.php');
?>
<div class="centerColumn" id="productGeneral">

<?php if ($messageStack->size('product_info') > 0) echo $messageStack->output('product_info'); ?>

<!--bof Category Icon -->
<?php if (($module_show_categories != 0) && (MOBILE_CATEGORY_ICON_DISPLAY == 'true')) {?>
<?php
/**
 * display the category icons
 */
require($template->get_template_dir('/tpl_modules_category_icon_display.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_category_icon_display.php'); ?>
<?php } ?>
<!--eof Category Icon -->

<!--bof Prev/Next top position -->
<?php if ((PRODUCT_INFO_PREVIOUS_NEXT == 1 or PRODUCT_INFO_PREVIOUS_NEXT == 3) && (MOBILE_NEXT_PREVIOUS_BUTTONS == 'true')) { ?>
<?php
/**
 * display the product previous/next helper
 */
require($template->get_template_dir('/tpl_products_next_previous.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_products_next_previous.php'); ?>
<?php } ?>
<!--eof Prev/Next top position-->

<!--bof Main Product Image -->
<?php
  if (zen_not_null($products_image)) {
  ?>
<?php
/**
 * display the main product image
 */
	echo '<div style="width:100%">';
	echo '<span style="width:65% ; display:inline-table ; float:left">';
	require($template->get_template_dir('/tpl_modules_main_product_image.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_main_product_image.php'); 
	echo '</span>';
	echo '<span style="width:35% ; display:inline-table ; float:left">';
	if ( (($flag_show_product_info_model == 1 and $products_model != '') or ($flag_show_product_info_weight == 1 and $products_weight !=0) or ($flag_show_product_info_quantity == 1) or ($flag_show_product_info_manufacturer == 1 and !empty($manufacturers_name))) or ($flag_show_product_info_date_available == 1) or ((zen_not_null($products_url)) and ($flag_show_product_info_url == 1)) ) 
	{
		echo jqm_listview('123','id="productDetailsList"'); 
		echo '<li data-role="list-divider">'.strtoupper($products_name).'</li>';
		echo '<li><span class="text_half">' . TEXT_PRODUCT_MODEL . '</span> '.$products_model . '</li>'; 
		$inches = $product_info->fields['products_size'] ; 
		$inches_full = '<img src="' . 'images/' . $inches . 'inch.gif' . '">' ;
		if (!empty($product_info->fields['products_sides'])) { echo '<li><span class="text_half">Sides:</span> '.substr($product_info->fields['products_sides'],0,1) . '</li>';}
		if (!empty($product_info->fields['products_size'])) { echo '<li><span class="text_half">Size: </span>' . $inches . ' INCHES</li>'; }
		$imgtag1 = !empty($product_info->fields['products_imgtag']) ? '&nbsp;&nbsp;<img src="'.DIR_WS_IMAGES . '/'.$product_info->fields['products_imgtag'].'">': '';
		$imgtag2 = !empty($product_info->fields['products_imgtag_alt']) ? '&nbsp;&nbsp;&nbsp;&nbsp;<img src="'.DIR_WS_IMAGES . '/'.$product_info->fields['products_imgtag_alt'].'">': '';
		if (!empty($product_info->fields['products_imgtag']) || !empty($product_info->fields['products_imgtag_alt'])) { echo '<li><span class="text_half">Features:</span><span class="text_half">'.$imgtag1.$imgtag2.'</span>'; }
		if ($show_onetime_charges_description == 'true') {
		$one_time = '<span >' . TEXT_ONETIME_CHARGE_SYMBOL . TEXT_ONETIME_CHARGE_DESCRIPTION . '</span><br />';
		} else {
			$one_time = '';
		}
		$product_price = zen_get_products_display_price((int)$_GET['products_id']);
		$display_price = $one_time . ((zen_has_product_attributes_values((int)$_GET['products_id']) and $flag_show_product_info_starting_at == 1) ? TEXT_BASE_PRICE : '') . zen_get_products_display_price((int)$_GET['products_id']);
		//$cents = ltrim(filter_var($display_price,FILTER_SANITIZE_NUMBER_FLOAT),0) . '&cent';
		//$display_price = ($display_price < 1) ? $cents : $display_price;
		$product_min = zen_get_products_quantity_order_min((int)$_GET['products_id']) ;
		if(stripos($product_info->fields['products_name'], 'latex') !== false)
		{
			//this is a latex product, don't show the normal order minimum, show the pack count
			$pack_count = intval(preg_replace('/[^0-9]+/', '', $product_info->fields['products_sides']), 10);
			$latex = true;
		}

		if($latex)
		{
			echo '<li><span class="text_half">Count: </span> '.$pack_count.' per pack</li>';
		}
		elseif($product_min > 0) 
		{ 
			echo '<li><span class="text_half">Note: </span> Sold in groups of '.$product_min.'</li>';
		}
		echo '<li><span class="text_half">Price: </span> '.$display_price.' each</li>';
		echo jqm_noajax_form('cart_quantity', zen_href_link(zen_get_info_page($_GET['products_id']), zen_get_all_get_params(array('action')) . 'action=add_product', $request_type), 'post', 'enctype="multipart/form-data"') . "\n";
		$display_qty = (($flag_show_product_info_in_cart_qty == 1 and $_SESSION['cart']->in_cart($_GET['products_id'])) ? '<p>' . PRODUCTS_ORDER_QTY_TEXT_IN_CART . $_SESSION['cart']->get_quantity($_GET['products_id']) . '</p>' : '');
		$min_units = zen_get_products_quantity_order_units($_GET['products_id']);
		if ($products_qty_box_status == 0 or $products_quantity_order_max== 1) {
			// hide the quantity box and default to 1
			$the_button = '<input type="hidden" name="cart_quantity" value="'.$product_min.'" />' . zen_draw_hidden_field('products_id', (int)$_GET['products_id']) . jqm_submit_button(BUTTON_IMAGE_IN_CART, BUTTON_IN_CART_ALT);
		} else {
			// show the quantity box$the_button  = '<div class="ui-grid-a">';
			$the_button .= '<div class="ui-block-a">';
			$the_button .= product_info_add_to_cart(zen_get_buy_now_qty($_GET['products_id']), $product_min, $min_units);
			$the_button .= '</div><div class="ui-block-b">';
			$the_button .= zen_draw_hidden_field('products_id', (int)$_GET['products_id']) . jqm_submit_button(BUTTON_IMAGE_ADD_TO_CART, BUTTON_IN_CART_ALT);
			$the_button .= '</div>';
			$the_button .= '</div>';
		}
		$display_button = zen_get_buy_now_button($_GET['products_id'], $the_button);
		echo '<li>'.$display_button.'</li>';
		echo (($flag_show_product_info_weight == 1 and $products_weight !=0) ? '<li>' . TEXT_PRODUCT_WEIGHT .  $products_weight . TEXT_PRODUCT_WEIGHT_UNIT . '</li>'  : '') . "\n"; 
		echo (($flag_show_product_info_quantity == 1) ? '<li>' . $products_quantity . TEXT_PRODUCT_QUANTITY . '</li>'  : '') . "\n"; 
		echo (($flag_show_product_info_manufacturer == 1 and !empty($manufacturers_name)) ? '<li>' . TEXT_PRODUCT_MANUFACTURER . $manufacturers_name . '</li>' : '') . "\n";
		if ($products_date_available > date('Y-m-d H:i:s')) {
			if ($flag_show_product_info_date_available == 1) {
				echo '<li>'.sprintf(TEXT_DATE_AVAILABLE, zen_date_long($products_date_available)).'</li>';
			}
		} else {
			if ($flag_show_product_info_date_added == 1) {
				echo '<li>'.sprintf(TEXT_DATE_ADDED, zen_date_long($products_date_added)).'</li>';
			} // $flag_show_product_info_date_added
		}

		/*if (zen_not_null($products_url)) {
			if ($flag_show_product_info_url == 1) {
				echo '<li>'.sprintf(TEXT_MORE_INFORMATION, zen_href_link(FILENAME_REDIRECT, 'action=product&products_id=' . zen_output_string_protected($_GET['products_id']), 'NONSSL', true, false)).'</li>';
			} // $flag_show_product_info_url
		}*/
		echo '</ul>';
	}
	/*echo '<h1 id="productName" class="productGeneral">'.$products_name.'</h1>';
	$inches = $product_info->fields['products_size'] ; 
	$inches_full = '<img src="' . 'images/' . $inches . 'inch.gif' . '">' ;
	if (!empty($product_info->fields['products_size'])) {
		echo '<span class="pinfo_balloonsize">' . $inches . '</span><br /><span class="pinfo_balloonsize_suffix">INCHES</span><br />'; 
	}
	echo 'Model<br />';
	echo 'Price<br />';
	echo 'Button and Qty<br />';*/
	echo '</span><br /></div>';
  }
		echo '</div>';
	echo '</div>';
echo '</form>';
echo '<br /><br /></div>';
if ($products_description != '') { ?>
    <div class="ui-block-a">
        <div class="ui-body ui-body-d">
            <h2><?php echo HEADING_DESCRIPTION; ?></h2>

            <div class="product-description"><?php echo stripslashes($products_description); ?></div>

        </div>
    </div><!-- secondary story block #1 -->
<?php } ?>

<!--bof Quantity Discounts table -->
<?php
  if ($products_discount_type != 0) { ?>
<?php
/**
 * display the products quantity discount
 */
 require($template->get_template_dir('/tpl_modules_products_quantity_discounts.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_products_quantity_discounts.php'); ?>
<?php
  }
?>
<!--eof Quantity Discounts table -->

<!--bof Additional Product Images -->
<?php
/**
 * display the products additional images
 */
  require($template->get_template_dir('/tpl_modules_additional_images.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_additional_images.php'); ?>
<!--eof Additional Product Images -->

<!--bof Prev/Next bottom position -->
<?php if ((PRODUCT_INFO_PREVIOUS_NEXT == 2 or PRODUCT_INFO_PREVIOUS_NEXT == 3) && (MOBILE_NEXT_PREVIOUS_BUTTONS == 'true')) { ?>
<?php
/**
 * display the product previous/next helper
 */
 require($template->get_template_dir('/tpl_products_next_previous.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_products_next_previous.php'); ?>
<?php } ?>
<!--eof Prev/Next bottom position -->

<!--bof Reviews button and count-->
<?php
  if ($flag_show_product_info_reviews == 1) {
    // if more than 0 reviews, then show reviews button; otherwise, show the "write review" button
    if ($reviews->fields['count'] > 0 ) { ?>
	<div class="button-row ui-grid-a">
		<div id="productReviewLink" class="ui-block-a pull-left">
			<?php echo '<a href="' . zen_href_link(FILENAME_PRODUCT_REVIEWS, zen_get_all_get_params()) . '"' . jqm_anchor_button(false) . '>' . BUTTON_REVIEWS_ALT . '</a>'; ?>
		</div>
		<div class="ui-block-b">

		</div>
	</div>
<p class="reviewCount"><?php echo ($flag_show_product_info_reviews_count == 1 ? TEXT_CURRENT_REVIEWS . ' ' . $reviews->fields['count'] : ''); ?></p>
<?php } else { ?>

	<div class="button-row ui-grid-a">
		<div class="ui-block-a pull-left">
			<?php echo '<a href="' . zen_href_link(FILENAME_PRODUCT_REVIEWS_WRITE, zen_get_all_get_params(array())) . '"' . jqm_anchor_button(false) . '>' . BUTTON_WRITE_REVIEW_ALT . '</a>'; ?>
		</div>
		<div class="ui-block-b">

		</div>
	</div>

<?php
  }
}
?>
<!--eof Reviews button and count -->

<!--bof also purchased products module-->
<?php require($template->get_template_dir('tpl_modules_also_purchased_products.php', DIR_WS_TEMPLATE, $current_page_base,'templates'). '/' . 'tpl_modules_also_purchased_products.php');?>
<!--eof also purchased products module-->


</form>

</div>