<?php
/**
 * Page Template
 *
 * Loaded automatically by index.php?main_page=shopping_cart.<br />
 * Displays shopping-cart contents
 *
 * @package templateSystem
 * @copyright Copyright 2003-2010 Zen Cart Development Team
 * @copyright Portions Copyright 2003 osCommerce
 * @license http://www.zen-cart.com/license/2_0.txt GNU Public License V2.0
 * @version $Id: tpl_shopping_cart_default.php 15881 2010-04-11 16:32:39Z wilt $
 */
?>
<div class="centerColumn" id="shoppingCartDefault">
<?php
  if ($flagHasCartContents) {
?>

<h1 id="cartDefaultHeading"><?php echo HEADING_TITLE; ?></h1>

<?php
  if ($_SESSION['cart']->count_contents() > 0) {
?>
<div class="text-right"><?php echo TEXT_VISITORS_CART; ?></div>
<?php
  }
?>

<?php if ($messageStack->size('shopping_cart') > 0) echo $messageStack->output('shopping_cart'); ?>

<?php echo jqm_noajax_form('cart_quantity', zen_href_link(FILENAME_SHOPPING_CART, 'action=update_product', $request_type)); ?>

<?php if (!empty($totalsDisplay)) { ?>
  <div class="cartTotalsDisplay important"><?php echo $totalsDisplay; ?></div>
  <br class="clearBoth" />
<?php } ?>

<?php  if ($flagAnyOutOfStock) { ?>

<?php    if (STOCK_ALLOW_CHECKOUT == 'true') {  ?>

<div class="messageStackError"><?php echo OUT_OF_STOCK_CAN_CHECKOUT; ?></div>

<?php    } else { ?>
<div class="messageStackError"><?php echo OUT_OF_STOCK_CANT_CHECKOUT; ?></div>

<?php    } //endif STOCK_ALLOW_CHECKOUT ?>
<?php  } //endif flagAnyOutOfStock ?>

<table  data-role="table" data-mode="reflow" id="cartContentsDisplay" class="ui-responsive">
	<thead>
		<tr class="tableHeading">
			<th data-priority="1" id="scProductsHeading"><?php echo TABLE_HEADING_PRODUCTS; ?></th>
			<th data-priority="2" id="scQuantityHeading"><?php echo TABLE_HEADING_QUANTITY; ?></th>
			<th data-priority="4" id="scUnitHeading"><?php echo TABLE_HEADING_PRICE; ?></th>
			<th data-priority="5" id="scTotalHeading"><?php echo TABLE_HEADING_TOTAL; ?></th>
			<th data-priority="6" id="scRemoveHeading"><?php echo TABLE_HEADING_REMOVE; ?></th>
		</tr>
	</thead>
	<tbody>
         <!-- Loop through all products /-->
<?php
  foreach ($productArray as $product) {
?>
     <tr>

       <td class="cartProductDisplay">

    <div class="ui-grid-a">
        <div class="ui-block-a">

                <?php echo $product['productsImage']; ?>

        </div>

        <div class="ui-block-b">
				<a href="<?php echo $product['linkProductsName']; ?>"><?php echo $product['productsName'] . '<span class="alert bold">' . $product['flagStockCheck'] . '</span>'; ?></a>
<br class="clearBoth" />

<?php
  echo $product['attributeHiddenField'];
  if (isset($product['attributes']) && is_array($product['attributes'])) {
  echo '<div class="cartAttribsList">';
  echo '<ul data-role="listview">';
    reset($product['attributes']);
    foreach ($product['attributes'] as $option => $value) {
?>

<li><?php echo $value['products_options_name'] . TEXT_OPTION_DIVIDER . nl2br($value['products_options_values_name']); ?></li>

<?php
    }
  echo '</ul>';
  echo '</div>';
  }
?>

        </div>
    </div><!-- /grid-a -->

       </td>


       <td class="qty-block">

    <div class="ui-grid-a">
        <div id="cart-update-input" class="ui-block-a">

<?php
  if ($product['flagShowFixedQuantity']) {
    echo $product['showFixedQuantityAmount'] . '<br /><span class="alert bold">' . $product['flagStockCheck'] . '</span><br /><br />' . $product['showMinUnits'];
  } else {
    echo $product['quantityField'] . '<br /><span class="alert bold">' . $product['flagStockCheck'] . '</span><br /><br />' . $product['showMinUnits'];
  }
?>

        </div>

        <div class="ui-block-b">

<?php
  if ($product['buttonUpdate'] == '') {
    echo '' ;
  } else {
    echo $product['buttonUpdate'];
  }
?>

        </div>
    </div><!-- /grid-a -->

       </td>

       <td class="cartUnitDisplay"><?php echo $product['productsPriceEach']; ?></td>
       <td class="cartTotalDisplay"><?php echo $product['productsPrice']; ?></td>
       <td class="cartRemoveItemDisplay">
<?php
  //if ($product['buttonDelete']) {
  if (($product['buttonDelete']) or ($product['checkBoxDelete'])) {
?>
           <a href="<?php echo zen_href_link(FILENAME_SHOPPING_CART, 'action=remove_product&product_id=' . $product['id']); ?>" data-ajax="false" <?php echo jqm_button_widget(true,'delete','notext',false,false,'a',false,true,false,true) . '">' . ICON_TRASH_ALT; ?></a>
<?php
  }
/*
  if ($product['checkBoxDelete']) {
    echo '<!--<fieldset data-role="controlgroup" data-type="horizontal">--><label>' . zen_draw_checkbox_field('cart_delete[]', $product['id']) . CHECKBOX_TRASH_LABEL . '</label><!--</fieldset>-->';
  }
*/
?>
</td>
     </tr>
<?php
  } // end foreach ($productArray as $product)
?>
       <!-- Finished loop through all products /-->
	</tbody>
      </table>

<div id="cartSubTotal" class="text-right"><?php echo SUB_TITLE_SUB_TOTAL; ?> <?php echo $cartShowTotal; ?></div>
<br class="clearBoth" />

<!--bof shopping cart buttons-->

    <div class="rwd-grid-b">
        <!-- Lead story block -->

        <div class="ui-block-a">

                <?php echo '<a href="' . zen_href_link(FILENAME_CHECKOUT_SHIPPING, '', 'SSL') . '"' . jqm_button_widget(true,'','',false,false,SUBMIT_BTN_THEME,false,false,false,false) . '">' . BUTTON_CHECKOUT_ALT . '</a>'; ?>

        </div><!-- secondary story block #1 -->

        <div class="ui-block-b">

                <?php echo jqm_back_link() . jqm_button_widget(true,'','',false,false,ANCHOR_BTN_THEME,false,false,false,false) . '">' . BUTTON_CONTINUE_SHOPPING_ALT . '</a>'; ?>

        </div><!-- secondary story block #2 -->

    </div><!-- /rwd-grid-b -->



<?php
// show update cart button
  if (SHOW_SHOPPING_CART_UPDATE == 2 or SHOW_SHOPPING_CART_UPDATE == 3) {
?>


    <div class="rwd-grid-b">
        <!-- Lead story block -->

        <div class="ui-block-a text-center">

                <?php echo jqm_icon_submit(ICON_IMAGE_UPDATE, ICON_UPDATE_ALT, DATA_ICON_REFRESH); ?>

        </div><!-- secondary story block #1 -->

        <div class="ui-block-b">

        </div><!-- secondary story block #2 -->

    </div><!-- /rwd-grid-b -->


<div class="buttonRow back"></div>
<?php
  } else { // don't show update button below cart
?>
<?php
  } // show update button
?>
<!--eof shopping cart buttons-->
</form>

<br class="clearBoth" />
<?php
    if (SHOW_SHIPPING_ESTIMATOR_BUTTON == '1') {
?>
<div data-role="collapsible">
	<h4><?php echo BUTTON_SHIPPING_ESTIMATOR_ALT; ?></h4>
	<?php require(DIR_WS_MODULES . zen_get_module_directory('shipping_estimator.php')); ?>
</div>
<?php
    }
?>

<!-- ** BEGIN PAYPAL EXPRESS CHECKOUT ** -->
<?php  // the tpl_ec_button template only displays EC option if cart contents >0 and value >0
if (defined('MODULE_PAYMENT_PAYPALWPP_STATUS') && MODULE_PAYMENT_PAYPALWPP_STATUS == 'True') {
  include(DIR_FS_CATALOG . DIR_WS_MODULES . 'payment/paypal/tpl_ec_button.php');
}
?>
<!-- ** END PAYPAL EXPRESS CHECKOUT ** -->

<?php
      if (SHOW_SHIPPING_ESTIMATOR_BUTTON == '2') {
/**
 * load the shipping estimator code if needed
 */
?>
      <?php require(DIR_WS_MODULES . zen_get_module_directory('shipping_estimator.php')); ?>

<?php
      }
?>
<?php
  } else {
?>

<h2 id="cartEmptyText"><?php echo TEXT_CART_EMPTY; ?></h2>

<?php
$show_display_shopping_cart_empty = $db->Execute(SQL_SHOW_SHOPPING_CART_EMPTY);

while (!$show_display_shopping_cart_empty->EOF) {
?>

<?php
  if ($show_display_shopping_cart_empty->fields['configuration_key'] == 'SHOW_SHOPPING_CART_EMPTY_FEATURED_PRODUCTS') { ?>
<?php
/**
 * display the Featured Products Center Box
 */
?>
<?php require($template->get_template_dir('tpl_modules_featured_products.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_featured_products.php'); ?>
<?php } ?>

<?php
  if ($show_display_shopping_cart_empty->fields['configuration_key'] == 'SHOW_SHOPPING_CART_EMPTY_SPECIALS_PRODUCTS') { ?>
<?php
/**
 * display the Special Products Center Box
 */
?>
<?php require($template->get_template_dir('tpl_modules_specials_default.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_specials_default.php'); ?>
<?php } ?>

<?php
  if ($show_display_shopping_cart_empty->fields['configuration_key'] == 'SHOW_SHOPPING_CART_EMPTY_NEW_PRODUCTS') { ?>
<?php
/**
 * display the New Products Center Box
 */
?>
<?php require($template->get_template_dir('tpl_modules_whats_new.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_modules_whats_new.php'); ?>
<?php } ?>

<?php
  if ($show_display_shopping_cart_empty->fields['configuration_key'] == 'SHOW_SHOPPING_CART_EMPTY_UPCOMING') {
    include(DIR_WS_MODULES . zen_get_module_directory(FILENAME_UPCOMING_PRODUCTS));
  }
?>
<?php
  $show_display_shopping_cart_empty->MoveNext();
} // !EOF
?>
<?php
  }
?>
</div>

<?php require($template->get_template_dir('tpl_info_shopping_cart_default.php',DIR_WS_TEMPLATE, $current_page_base,'templates'). '/tpl_info_shopping_cart_default.php'); ?>
